<?php
// Script to update a setting in the database

require_once __DIR__ . '/database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check if setting exists
    $checkSql = "SELECT id FROM system_settings WHERE setting_key = ?";
    $stmt = $pdo->prepare($checkSql);
    $stmt->execute(['chairmanProfilePhoto']);
    $existing = $stmt->fetch();
    
    if ($existing) {
        // Update existing setting
        $sql = "UPDATE system_settings SET setting_value = ?, description = ? WHERE setting_key = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'Officials Photos/test_1761833624.png',
            'Chairman Profile Photo',
            'chairmanProfilePhoto'
        ]);
    } else {
        // Insert new setting
        $sql = "INSERT INTO system_settings (setting_key, setting_value, description) VALUES (?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'chairmanProfilePhoto',
            'Officials Photos/test_1761833624.png',
            'Chairman Profile Photo'
        ]);
    }
    
    echo "Setting updated successfully!";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>