<?php
// Test script to check if the PDF generation fix works

require_once __DIR__ . '/api/generate-project-members-pdf.php';

// Test data
$members = [
    [
        'member_id' => 'M001',
        'first_name' => 'John',
        'last_name' => 'Doe',
        'role' => 'Project Manager',
        'contribution_amount' => 5000,
        'joined_date' => '2023-01-15',
        'member_project_status' => 'Active'
    ],
    [
        'member_id' => 'M002',
        'first_name' => 'Jane',
        'last_name' => 'Smith',
        'role' => 'Developer',
        'contribution_amount' => 3000,
        'joined_date' => '2023-02-20',
        'member_project_status' => 'Active'
    ]
];

try {
    // Test HTML generation
    $html = generateProjectMembersHtml($members, 'Test Project');
    echo "HTML generation: SUCCESS\n";
    
    // Test if Dompdf classes are available
    if (class_exists('Dompdf\Dompdf')) {
        echo "Dompdf classes: AVAILABLE\n";
    } else {
        echo "Dompdf classes: NOT AVAILABLE\n";
    }
    
    echo "Test completed successfully.\n";
} catch (Exception $e) {
    echo "Test failed with error: " . $e->getMessage() . "\n";
}
?>