<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Test the exact query that's failing
    $sql = "SELECT p.id, p.name, p.description, p.location, p.completion_date, p.status as status, p.total_shares, p.share_price,
                   mp.status as role, mp.amount_contributed as contribution_amount, mp.join_date as joined_date, mp.status as member_project_status,
                   p.created_at, p.updated_at
            FROM projects p
            JOIN member_projects mp ON p.id = mp.project_id
            WHERE mp.member_id = ?
            ORDER BY p.completion_date DESC";
    
    $stmt = $pdo->prepare($sql);
    // Use a test member ID (1) to see if the query works
    $stmt->execute([1]);
    $results = $stmt->fetchAll();
    
    echo "Query executed successfully!\n";
    echo "Number of results: " . count($results) . "\n";
    
    if (count($results) > 0) {
        echo "Sample result:\n";
        print_r($results[0]);
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    
    // Let's also check what columns actually exist
    try {
        $stmt = $pdo->query("DESCRIBE member_projects");
        $columns = $stmt->fetchAll();
        echo "\nActual columns in member_projects table:\n";
        foreach ($columns as $column) {
            echo "- " . $column['Field'] . " (" . $column['Type'] . ")\n";
        }
    } catch (Exception $e2) {
        echo "Failed to describe table: " . $e2->getMessage() . "\n";
    }
}
?>