<?php
// Test script to check if member MFT22269913 has projects assigned
require_once 'database/config.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>Test Member Project Assignment</title>
</head>
<body>
<h1>Testing Member Project Assignment</h1>";

// Check if member exists
$member_sql = "SELECT id, member_id, first_name, last_name FROM members WHERE member_id = 'MFT22269913'";
$member = fetchSingleRow($member_sql, []);

if (!$member) {
    echo "<p>Member MFT22269913 not found in the database</p>";
    
    // Let's check what members exist in the database
    echo "<h2>Existing Members:</h2>";
    $all_members_sql = "SELECT id, member_id, first_name, last_name FROM members";
    $all_members = executeQuery($all_members_sql, []);
    
    if (empty($all_members)) {
        echo "<p>No members found in the database</p>";
    } else {
        echo "<ul>";
        foreach ($all_members as $m) {
            echo "<li>" . $m['member_id'] . " - " . $m['first_name'] . " " . $m['last_name'] . " (ID: " . $m['id'] . ")</li>";
        }
        echo "</ul>";
    }
} else {
    echo "<p>Member found: " . $member['first_name'] . " " . $member['last_name'] . " (" . $member['member_id'] . ")</p>";
    echo "<p>Database ID: " . $member['id'] . "</p>";

    // Check if member has any projects assigned
    $projects_sql = "SELECT p.id, p.name, mp.status, mp.amount_contributed, mp.join_date 
                     FROM projects p
                     JOIN member_projects mp ON p.id = mp.project_id
                     WHERE mp.member_id = ?";

    $projects = executeQuery($projects_sql, [$member['id']]);

    if (empty($projects)) {
        echo "<p>No projects found for this member</p>";
        
        // Let's check all member-project assignments
        echo "<h2>All Member-Project Assignments:</h2>";
        $all_assignments_sql = "SELECT m.member_id, m.first_name, m.last_name, p.name as project_name, mp.status, mp.amount_contributed, mp.join_date
                                FROM member_projects mp
                                JOIN members m ON mp.member_id = m.id
                                JOIN projects p ON mp.project_id = p.id";
        $all_assignments = executeQuery($all_assignments_sql, []);
        
        if (empty($all_assignments)) {
            echo "<p>No member-project assignments found</p>";
        } else {
            echo "<table border='1'>
                    <tr>
                        <th>Member ID</th>
                        <th>Name</th>
                        <th>Project</th>
                        <th>Status</th>
                        <th>Amount</th>
                        <th>Join Date</th>
                    </tr>";
            foreach ($all_assignments as $assignment) {
                echo "<tr>
                        <td>" . $assignment['member_id'] . "</td>
                        <td>" . $assignment['first_name'] . " " . $assignment['last_name'] . "</td>
                        <td>" . $assignment['project_name'] . "</td>
                        <td>" . $assignment['status'] . "</td>
                        <td>" . $assignment['amount_contributed'] . "</td>
                        <td>" . $assignment['join_date'] . "</td>
                      </tr>";
            }
            echo "</table>";
        }
    } else {
        echo "<p>Found " . count($projects) . " project(s) assigned to this member:</p>";
        echo "<ul>";
        foreach ($projects as $project) {
            echo "<li>" . $project['name'] . " (ID: " . $project['id'] . ") - Status: " . $project['status'] . 
                 " - Contribution: " . $project['amount_contributed'] . " - Joined: " . $project['join_date'] . "</li>";
        }
        echo "</ul>";
    }
}

// Check all projects to see if "Konza Land" exists
$all_projects_sql = "SELECT id, name FROM projects WHERE name LIKE '%Konza%'";
$all_projects = executeQuery($all_projects_sql, []);

if (empty($all_projects)) {
    echo "<p>No projects with 'Konza' in the name found</p>";
    
    // Let's check all projects
    echo "<h2>All Projects:</h2>";
    $all_proj_sql = "SELECT id, name FROM projects";
    $all_proj = executeQuery($all_proj_sql, []);
    
    if (empty($all_proj)) {
        echo "<p>No projects found in the database</p>";
    } else {
        echo "<ul>";
        foreach ($all_proj as $p) {
            echo "<li>" . $p['name'] . " (ID: " . $p['id'] . ")</li>";
        }
        echo "</ul>";
    }
} else {
    echo "<p>Projects with 'Konza' in the name:</p>";
    echo "<ul>";
    foreach ($all_projects as $project) {
        echo "<li>" . $project['name'] . " (ID: " . $project['id'] . ")</li>";
    }
    echo "</ul>";
}

echo "</body>
</html>";
?>