<?php
// Test script to check if member ID 14 exists
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check if member with ID 14 exists
    $stmt = $pdo->prepare("SELECT id, member_id, first_name, last_name FROM members WHERE id = ?");
    $stmt->execute([14]);
    $member = $stmt->fetch();
    
    if ($member) {
        echo "Member found:\n";
        print_r($member);
    } else {
        echo "Member with ID 14 not found\n";
        
        // List all members to see what's available
        echo "\nAll members:\n";
        $allStmt = $pdo->query("SELECT id, member_id, first_name, last_name FROM members");
        $members = $allStmt->fetchAll();
        foreach ($members as $m) {
            echo "ID: {$m['id']}, Member ID: {$m['member_id']}, Name: {$m['first_name']} {$m['last_name']}\n";
        }
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>