<?php
// Test script to check loans API functionality
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    echo "Database connection successful\n";
    
    // Check if loans table exists and has data
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM loans");
    $result = $stmt->fetch();
    echo "Loans count: " . $result['count'] . "\n";
    
    // Try to fetch some loans
    $stmt = $pdo->query("SELECT * FROM loans LIMIT 5");
    $loans = $stmt->fetchAll();
    echo "Sample loans:\n";
    foreach ($loans as $loan) {
        echo "- Loan ID: " . $loan['id'] . ", Reference: " . $loan['reference'] . ", Status: " . $loan['status'] . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>