<?php
// Test script to check loan agreement generation
require_once 'database/config.php';
require_once 'api/loan-agreement-generator.php';

// Test data
$loanData = [
    'loanRef' => 'LOAN-TEST-' . date('Ymd'),
    'agreementDate' => date('F j, Y'),
    'lenderName' => 'MFT SELF HELP GROUP',
    'lenderRegNo' => 'REG-2025-001',
    'lenderAddress' => 'Nairobi, Kenya',
    'borrowerName' => 'Test Borrower',
    'borrowerMemberNo' => 'MFT123456',
    'borrowerId' => '12345678',
    'borrowerAddress' => 'Test Address, Nairobi',
    'borrowerPhone' => '+254700123456',
    'loanType' => 'Emergency',
    'loanPurpose' => 'Business: Business Stock',
    'principalAmount' => 1000.00,
    'interestRate' => 10.00,
    'totalAmount' => 1100.00,
    'repaymentPeriod' => 7,
    'monthlyPayment' => 183.33,
    'applicationDate' => date('F j, Y'),
    'approvalDate' => date('F j, Y'),
    'disbursementDate' => date('F j, Y'),
    'firstPaymentDate' => date('F j, Y', strtotime('+1 month')),
    'lenderRep' => 'Treasurer',
    'verificationUrl' => 'https://mft-group.org/verify/',
    'schedule' => [
        ['number' => 1, 'date' => 'Nov 2025', 'principal' => 83.33, 'interest' => 100.00, 'total' => 183.33, 'balance' => 916.67],
        ['number' => 2, 'date' => 'Dec 2025', 'principal' => 91.66, 'interest' => 91.67, 'total' => 183.33, 'balance' => 825.01],
        ['number' => 3, 'date' => 'Jan 2026', 'principal' => 100.83, 'interest' => 82.50, 'total' => 183.33, 'balance' => 724.18],
        ['number' => 4, 'date' => 'Feb 2026', 'principal' => 110.91, 'interest' => 72.42, 'total' => 183.33, 'balance' => 613.27],
        ['number' => 5, 'date' => 'Mar 2026', 'principal' => 122.00, 'interest' => 61.33, 'total' => 183.33, 'balance' => 491.26],
        ['number' => 6, 'date' => 'Apr 2026', 'principal' => 134.20, 'interest' => 49.13, 'total' => 183.33, 'balance' => 357.06],
        ['number' => 7, 'date' => 'May 2026', 'principal' => 147.62, 'interest' => 35.71, 'total' => 183.33, 'balance' => 209.43]
    ]
];

echo "Testing loan agreement generation...\n";

// Generate the loan agreement
$result = generateLoanAgreement($loanData, 'F');

if ($result) {
    echo "Loan agreement generated successfully at: " . $result . "\n";
} else {
    echo "Failed to generate loan agreement.\n";
}
?>