<?php
// Include necessary utilities
require_once __DIR__ . '/api/dompdf-utils.php';
require_once __DIR__ . '/api/pdf-utils.php';
require_once __DIR__ . '/api/loan-agreement-generator.php';

// Test data
$loanData = [
    'loanRef' => 'LOAN-TEST-20251106',
    'agreementDate' => 'November 6, 2025',
    'lenderName' => 'MFT SELF HELP GROUP',
    'lenderRegNo' => 'REG-2025-001',
    'lenderAddress' => 'Nairobi, Kenya',
    'borrowerName' => 'Hudson Nditsa',
    'borrowerMemberNo' => 'MFT22269913',
    'borrowerId' => '22269913',
    'borrowerAddress' => 'Kakamega',
    'borrowerPhone' => '+254720689698',
    'loanType' => 'Emergency',
    'loanPurpose' => 'Business: Business Stock',
    'principalAmount' => 2300.00,
    'interestRate' => 10.00,
    'totalAmount' => 2530.00,
    'repaymentPeriod' => 7,
    'monthlyPayment' => 361.43,
    'applicationDate' => 'November 6, 2025',
    'approvalDate' => 'November 6, 2025',
    'disbursementDate' => 'November 6, 2025',
    'firstPaymentDate' => 'December 6, 2025',
    'lenderRep' => 'Treasurer',
    'verificationUrl' => 'https://mft-group.org/verify/LOAN-TEST-20251106',
    'schedule' => [
        ['number' => 1, 'date' => 'Dec 2025', 'principal' => 198.10, 'interest' => 230.00, 'total' => 428.10, 'balance' => 2101.90],
        ['number' => 2, 'date' => 'Jan 2026', 'principal' => 217.91, 'interest' => 210.19, 'total' => 428.10, 'balance' => 1883.99],
        ['number' => 3, 'date' => 'Feb 2026', 'principal' => 239.70, 'interest' => 188.40, 'total' => 428.10, 'balance' => 1644.29],
        ['number' => 4, 'date' => 'Mar 2026', 'principal' => 263.67, 'interest' => 164.43, 'total' => 428.10, 'balance' => 1380.62],
        ['number' => 5, 'date' => 'Apr 2026', 'principal' => 289.04, 'interest' => 139.06, 'total' => 428.10, 'balance' => 1091.58],
        ['number' => 6, 'date' => 'May 2026', 'principal' => 318.94, 'interest' => 109.16, 'total' => 428.10, 'balance' => 772.64],
        ['number' => 7, 'date' => 'Jun 2026', 'principal' => 352.83, 'interest' => 75.27, 'total' => 428.10, 'balance' => 419.81]
    ]
];

// Generate HTML
$html = generateLoanAgreementHtml($loanData);

// Save HTML to file for inspection
file_put_contents(__DIR__ . '/documents/loan_agreements/detailed_test_agreement.html', $html);

echo "Detailed test agreement HTML saved to documents/loan_agreements/detailed_test_agreement.html\n";

// Also test QR code generation directly
$qrCode = generateQrCodeWithoutGd('LOAN-TEST-20251106');
echo "QR Code generated: " . ($qrCode ? "YES" : "NO") . "\n";
if ($qrCode) {
    echo "QR Code data URI length: " . strlen($qrCode) . " characters\n";
}

// Test signature retrieval
echo "Testing signature retrieval...\n";
// This would require a valid member ID from the database

// Now generate the actual PDF
echo "Generating PDF...\n";
$result = generateLoanAgreement($loanData, 'F'); // 'F' for file output

if ($result) {
    echo "PDF generated successfully at: " . $result . "\n";
} else {
    echo "Failed to generate PDF\n";
}