<?php
// Test database connection
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    echo "<h1>Database Connection Test</h1>";
    echo "<p>Connection successful!</p>";
    
    // Test a simple query
    $stmt = $pdo->query("SELECT VERSION() as version");
    $row = $stmt->fetch();
    echo "<p>MySQL Version: " . $row['version'] . "</p>";
    
    // Check if tables exist
    $stmt = $pdo->query("SHOW TABLES LIKE 'members'");
    $members_table = $stmt->fetch();
    
    if ($members_table) {
        echo "<p>Members table exists</p>";
        
        // Count members
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM members");
        $row = $stmt->fetch();
        echo "<p>Total members: " . $row['count'] . "</p>";
    } else {
        echo "<p>Members table does not exist</p>";
    }
    
    $stmt = $pdo->query("SHOW TABLES LIKE 'projects'");
    $projects_table = $stmt->fetch();
    
    if ($projects_table) {
        echo "<p>Projects table exists</p>";
        
        // Count projects
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM projects");
        $row = $stmt->fetch();
        echo "<p>Total projects: " . $row['count'] . "</p>";
    } else {
        echo "<p>Projects table does not exist</p>";
    }
    
    $stmt = $pdo->query("SHOW TABLES LIKE 'member_projects'");
    $member_projects_table = $stmt->fetch();
    
    if ($member_projects_table) {
        echo "<p>Member_Projects table exists</p>";
        
        // Count member-project assignments
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM member_projects");
        $row = $stmt->fetch();
        echo "<p>Total member-project assignments: " . $row['count'] . "</p>";
    } else {
        echo "<p>Member_Projects table does not exist</p>";
    }
    
} catch (Exception $e) {
    echo "<h1>Database Connection Test</h1>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "<p>Please check your database configuration in database/config.php</p>";
}
?>