<?php
// Test script to check banking settings in the database

require_once 'database/config.php';

try {
    // Check if banking settings exist
    $sql = "SELECT setting_key, setting_value, description 
            FROM system_settings 
            WHERE setting_key LIKE 'bank_%' OR setting_key LIKE 'mpesa_%'
            ORDER BY setting_key";
    
    $settings = executeQuery($sql);
    
    if (empty($settings)) {
        echo "No banking settings found in the database.\n";
        echo "You may need to run the init-banking-settings.php script.\n";
    } else {
        echo "Banking settings found in the database:\n";
        foreach ($settings as $setting) {
            echo "- " . $setting['setting_key'] . ": " . $setting['setting_value'] . "\n";
        }
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>