<?php
// Test script to approve a loan
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Test data - approve loan ID 2
    $loan_id = 2;
    $approver_id = 'ADM-2025-001'; // Member reference ID
    
    // First, get the numeric ID for the approver
    $member_check_sql = "SELECT id FROM members WHERE member_id = ?";
    $member_stmt = $pdo->prepare($member_check_sql);
    $member_stmt->execute([$approver_id]);
    $member_result = $member_stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$member_result) {
        echo "Error: Member not found\n";
        exit(1);
    }
    
    $approver_numeric_id = $member_result['id'];
    echo "Approver numeric ID: " . $approver_numeric_id . "\n";
    
    // Update the loan
    $sql = "UPDATE loans SET status = ?, approval_date = ?, approved_by = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $result = $stmt->execute(['Approved', date('Y-m-d'), $approver_numeric_id, $loan_id]);
    
    if ($result) {
        echo "Loan approved successfully\n";
        
        // Get the updated loan
        $select_sql = "SELECT l.*, m.first_name, m.last_name, m.member_id as member_ref 
                       FROM loans l
                       JOIN members m ON l.member_id = m.id
                       WHERE l.id = ?";
        $select_stmt = $pdo->prepare($select_sql);
        $select_stmt->execute([$loan_id]);
        $loan = $select_stmt->fetch(PDO::FETCH_ASSOC);
        
        print_r($loan);
    } else {
        echo "Error approving loan\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>