<!DOCTYPE html>
<html>
<head>
    <title>Test Agreement Generation</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .container { max-width: 800px; margin: 0 auto; }
        .result { background: #f0f0f0; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; }
        .debug { background: #fff3cd; border: 1px solid #ffeaa7; font-family: monospace; white-space: pre-wrap; }
    </style>
</head>
<body>
<div class="container">
    <h1>Test Agreement Generation</h1>
    
    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        require_once 'database/config.php';
        require_once 'api/loan-agreement-generator.php';
        
        echo "<div class='result'>Testing loan agreement generation...</div>";
        
        // Test data
        $loanData = [
            'loanRef' => 'LOAN-TEST-' . date('YmdHis'),
            'agreementDate' => date('F j, Y'),
            'lenderName' => 'MFT SELF HELP GROUP',
            'lenderRegNo' => 'REG-2025-001',
            'lenderAddress' => 'Nairobi, Kenya',
            'borrowerName' => 'Test Borrower',
            'borrowerMemberNo' => 'MFT123456',
            'borrowerId' => '12345678',
            'borrowerAddress' => 'Test Address, Nairobi',
            'borrowerPhone' => '+254700123456',
            'loanType' => 'Emergency',
            'loanPurpose' => 'Business: Business Stock',
            'principalAmount' => 1000.00,
            'interestRate' => 10.00,
            'totalAmount' => 1100.00,
            'repaymentPeriod' => 7,
            'monthlyPayment' => 183.33,
            'applicationDate' => date('F j, Y'),
            'approvalDate' => date('F j, Y'),
            'disbursementDate' => date('F j, Y'),
            'firstPaymentDate' => date('F j, Y', strtotime('+1 month')),
            'lenderRep' => 'Treasurer',
            'verificationUrl' => 'https://mft-group.org/verify/',
            'schedule' => [
                ['number' => 1, 'date' => 'Nov 2025', 'principal' => 83.33, 'interest' => 100.00, 'total' => 183.33, 'balance' => 916.67],
                ['number' => 2, 'date' => 'Dec 2025', 'principal' => 91.66, 'interest' => 91.67, 'total' => 183.33, 'balance' => 825.01],
                ['number' => 3, 'date' => 'Jan 2026', 'principal' => 100.83, 'interest' => 82.50, 'total' => 183.33, 'balance' => 724.18],
                ['number' => 4, 'date' => 'Feb 2026', 'principal' => 110.91, 'interest' => 72.42, 'total' => 183.33, 'balance' => 613.27],
                ['number' => 5, 'date' => 'Mar 2026', 'principal' => 122.00, 'interest' => 61.33, 'total' => 183.33, 'balance' => 491.26],
                ['number' => 6, 'date' => 'Apr 2026', 'principal' => 134.20, 'interest' => 49.13, 'total' => 183.33, 'balance' => 357.06],
                ['number' => 7, 'date' => 'May 2026', 'principal' => 147.62, 'interest' => 35.71, 'total' => 183.33, 'balance' => 209.43]
            ]
        ];
        
        echo "<div class='result'>Generating agreement with test data...</div>";
        
        // Enable error reporting
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        
        // Try to generate the agreement
        try {
            $result = generateLoanAgreement($loanData, 'F');
            
            echo "<div class='result'>Generate function returned: " . var_export($result, true) . "</div>";
            
            if ($result) {
                echo "<div class='result success'>Loan agreement generated successfully!</div>";
                echo "<div class='result'>Result: " . htmlspecialchars($result) . "</div>";
                
                // Check if file exists
                if (file_exists($result)) {
                    echo "<div class='result success'>File exists at: " . htmlspecialchars($result) . "</div>";
                    echo "<div class='result'>File size: " . filesize($result) . " bytes</div>";
                    echo "<div class='result'><a href='" . htmlspecialchars($result) . "' target='_blank'>Open Agreement</a></div>";
                } else {
                    echo "<div class='result error'>File does not exist at expected path</div>";
                    
                    // Check in documents directory
                    $possible_paths = [
                        $result,
                        'documents/' . basename($result),
                        'documents/loan_agreements/' . basename($result)
                    ];
                    
                    foreach ($possible_paths as $path) {
                        if (file_exists($path)) {
                            echo "<div class='result success'>Found file at: " . htmlspecialchars($path) . "</div>";
                            echo "<div class='result'><a href='" . htmlspecialchars($path) . "' target='_blank'>Open Agreement</a></div>";
                            break;
                        }
                    }
                }
            } else {
                echo "<div class='result error'>Failed to generate loan agreement</div>";
            }
        } catch (Exception $e) {
            echo "<div class='result error'>Exception: " . htmlspecialchars($e->getMessage()) . "</div>";
            echo "<div class='debug'>" . htmlspecialchars($e->getTraceAsString()) . "</div>";
        }
    } else {
    ?>
        <form method="POST">
            <p>This script will test the loan agreement generation function directly:</p>
            <button type="submit">Test Agreement Generation</button>
        </form>
    <?php } ?>
</div>
</body>
</html>