<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Test the exact query that the admin-users.php API uses to get admins
    $sql = "SELECT m.id, m.member_id, m.first_name, m.last_name, m.email, m.phone, m.role, 
                   mr.role_id, r.name as role_name, m.created_at, aac.access_code
            FROM members m
            JOIN member_roles mr ON m.id = mr.member_id
            JOIN roles r ON mr.role_id = r.id
            LEFT JOIN admin_access_codes aac ON m.id = aac.member_id
            WHERE r.name IN ('Admin', 'Treasurer', 'Secretary', 'Chairman', 'Assistant Chairman', 'Assistant Secretary', 'Loans Officer')
            ORDER BY m.created_at DESC";
    
    $stmt = $pdo->query($sql);
    $admins = $stmt->fetchAll();
    
    echo "Admins found: " . count($admins) . "\n";
    
    if (count($admins) > 0) {
        echo "Sample admin data:\n";
        print_r($admins[0]);
    } else {
        echo "No admins found. Let's check what roles exist in the database:\n";
        
        // Check what roles exist
        $roleSql = "SELECT * FROM roles";
        $roleStmt = $pdo->query($roleSql);
        $roles = $roleStmt->fetchAll();
        
        echo "Available roles:\n";
        foreach ($roles as $role) {
            echo "- ID: " . $role['id'] . ", Name: " . $role['name'] . "\n";
        }
        
        echo "\nLet's check if there are any members with roles:\n";
        $memberRoleSql = "SELECT m.id, m.member_id, m.first_name, m.last_name, r.name as role_name
                         FROM members m
                         JOIN member_roles mr ON m.id = mr.member_id
                         JOIN roles r ON mr.role_id = r.id
                         LIMIT 10";
        $memberRoleStmt = $pdo->query($memberRoleSql);
        $memberRoles = $memberRoleStmt->fetchAll();
        
        if (count($memberRoles) > 0) {
            echo "Members with roles:\n";
            foreach ($memberRoles as $memberRole) {
                echo "- " . $memberRole['first_name'] . " " . $memberRole['last_name'] . " (" . $memberRole['member_id'] . ") - Role: " . $memberRole['role_name'] . "\n";
            }
        } else {
            echo "No members with roles found.\n";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>