<?php
// Test the admin API endpoint directly
echo "Testing admin API endpoint...\n";

// Use cURL to test the API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://localhost/MFT/api/admin-users.php");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $httpCode . "\n";
echo "Response: " . $response . "\n";

if ($httpCode == 200) {
    echo "API is working correctly!\n";
    $data = json_decode($response, true);
    if ($data && isset($data['admins'])) {
        echo "Found " . count($data['admins']) . " admins\n";
        foreach ($data['admins'] as $admin) {
            echo "- " . $admin['name'] . " (" . implode(", ", $admin['role_names']) . ")\n";
        }
    }
} else {
    echo "API returned an error. Check the response above.\n";
}
?>