<?php
// Simple test to check if we can connect to the database and retrieve data
require_once 'database/config.php';

try {
    echo "Testing database connection...\n";
    $pdo = getDatabaseConnection();
    echo "Database connection successful!\n";
    
    // Test a simple query
    echo "\nTesting simple member query...\n";
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM members");
    $result = $stmt->fetch();
    echo "Total members: " . $result['count'] . "\n";
    
    // Test roles table
    echo "\nTesting roles table...\n";
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM roles");
    $result = $stmt->fetch();
    echo "Total roles: " . $result['count'] . "\n";
    
    // Test member_roles table
    echo "\nTesting member_roles table...\n";
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM member_roles");
    $result = $stmt->fetch();
    echo "Total member-role assignments: " . $result['count'] . "\n";
    
    if ($result['count'] > 0) {
        echo "\nSample member-role assignments:\n";
        $stmt = $pdo->query("SELECT mr.member_id, mr.role_id, m.first_name, m.last_name, r.name as role_name 
                            FROM member_roles mr 
                            JOIN members m ON mr.member_id = m.id 
                            JOIN roles r ON mr.role_id = r.id 
                            LIMIT 5");
        $assignments = $stmt->fetchAll();
        foreach ($assignments as $assignment) {
            echo "- " . $assignment['first_name'] . " " . $assignment['last_name'] . " (" . $assignment['role_name'] . ")\n";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>