<?php
// Simple script to create and approve a loan
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Get an active member
    $member_stmt = $pdo->prepare("SELECT id, member_id, first_name, last_name FROM members WHERE status = 'Active' LIMIT 1");
    $member_stmt->execute();
    $member = $member_stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$member) {
        echo "No active members found.\n";
        exit(1);
    }
    
    // Generate unique reference
    $reference = "LOAN-DEMO-" . date('YmdHis') . "-" . strtoupper(substr(md5(uniqid()), 0, 4));
    
    // Create test loan
    $insert_stmt = $pdo->prepare("INSERT INTO loans (reference, member_id, loan_type, principal_amount, interest_rate, total_amount, repayment_period, monthly_payment, purpose, application_date, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    $result = $insert_stmt->execute([
        $reference,
        $member['id'],
        'Emergency',
        5000.00,
        12.00,
        5600.00,
        6,
        933.33,
        'Demo loan for verification',
        date('Y-m-d'),
        'Pending'
    ]);
    
    if ($result) {
        $loan_id = $pdo->lastInsertId();
        echo "Created loan ID: $loan_id with reference: $reference\n";
        
        // Get admin user
        $admin_stmt = $pdo->prepare("SELECT id FROM members WHERE member_id LIKE 'ADM-%' LIMIT 1");
        $admin_stmt->execute();
        $admin = $admin_stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($admin) {
            // Approve the loan
            $update_stmt = $pdo->prepare("UPDATE loans SET status = ?, approval_date = ?, approved_by = ? WHERE id = ?");
            $update_result = $update_stmt->execute([
                'Approved',
                date('Y-m-d'),
                $admin['id'],
                $loan_id
            ]);
            
            if ($update_result) {
                echo "Loan $loan_id approved successfully!\n";
                echo "Expected agreement filename: loan_agreement_{$reference}_" . date('Y-m-d') . ".pdf\n";
                echo "Check in: documents/loan_agreements/\n";
            } else {
                echo "Failed to approve loan.\n";
            }
        } else {
            echo "No admin user found.\n";
        }
    } else {
        echo "Failed to create loan.\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>