// MFT GROUP Audit Trail Real-Time Updates
// This script handles real-time updates for the audit trail page

console.log('Audit Trail Real-Time script loaded');

// Function to initialize real-time updates for audit trail
function initializeAuditTrailRealTime() {
    console.log('Initializing audit trail real-time updates');
    
    try {
        // Initialize real-time client for admin
        if (typeof mftRealTime !== 'undefined') {
            mftRealTime.connect('admin');
            
            // Register update callback
            mftRealTime.onUpdate(function(data, dashboardType) {
                if (dashboardType === 'admin') {
                    console.log('Received real-time update for audit trail:', data);
                    
                    // Update all audit trail tabs with real-time data
                    updateAllAuditTrailTabs(data);
                }
            });
            
            console.log('Real-time updates started for audit trail');
        } else {
            console.warn('Real-time client not available');
        }
    } catch (error) {
        console.error('Error initializing audit trail real-time updates:', error);
    }
}

// Function to update all audit trail tabs with real-time data
function updateAllAuditTrailTabs(data) {
    console.log('Updating all audit trail tabs with real-time data:', data);
    
    // Refresh the current active tab to show new data
    const activeTab = document.querySelector('.nav-tab.active');
    if (activeTab) {
        const tabId = activeTab.getAttribute('data-tab');
        refreshAuditTrailTab(tabId, 1);
    }
}

// Function to refresh a specific audit trail tab
function refreshAuditTrailTab(tabId, page) {
    // Use global functions from the audit trail page
    switch(tabId) {
        case 'all':
            if (typeof loadAuditTrailPage === 'function') {
                loadAuditTrailPage(page);
            }
            break;
        case 'user':
            if (typeof loadUserActivitiesPage === 'function') {
                loadUserActivitiesPage(page);
            }
            break;
        case 'financial':
            if (typeof loadFinancialChangesPage === 'function') {
                loadFinancialChangesPage(page);
            }
            break;
        case 'system':
            if (typeof loadSystemEventsPage === 'function') {
                loadSystemEventsPage(page);
            }
            break;
        default:
            // If no specific tab, refresh all tabs
            refreshAllAuditTrailTabs(page);
            break;
    }
}

// Function to refresh all audit trail tabs
function refreshAllAuditTrailTabs(page) {
    if (typeof loadAuditTrailPage === 'function') {
        loadAuditTrailPage(page);
    }
    if (typeof loadUserActivitiesPage === 'function') {
        loadUserActivitiesPage(page);
    }
    if (typeof loadFinancialChangesPage === 'function') {
        loadFinancialChangesPage(page);
    }
    if (typeof loadSystemEventsPage === 'function') {
        loadSystemEventsPage(page);
    }
}

// Function to send audit trail notification
function sendAuditTrailNotification(notificationData) {
    if (typeof mftRealTime !== 'undefined') {
        mftRealTime.sendNotification({
            type: 'audit_trail_update',
            data: notificationData,
            target: 'admin'
        }).then(response => {
            console.log('Audit trail notification sent:', response);
        }).catch(error => {
            console.error('Error sending audit trail notification:', error);
        });
    }
}

// Export functions
window.initializeAuditTrailRealTime = initializeAuditTrailRealTime;
window.updateAllAuditTrailTabs = updateAllAuditTrailTabs;
window.refreshAuditTrailTab = refreshAuditTrailTab;
window.refreshAllAuditTrailTabs = refreshAllAuditTrailTabs;
window.sendAuditTrailNotification = sendAuditTrailNotification;

// Initialize when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Only initialize if we're on the audit trail page
    if (window.location.pathname.includes('audit-trail.html')) {
        initializeAuditTrailRealTime();
    }
});