<?php
// MFT GROUP Initialize Officials Settings via Web Interface
// This script initializes officials system settings when accessed via browser

// Include database configuration
require_once 'database/config.php';

// Only allow access via browser (not command line)
if (php_sapi_name() === 'cli') {
    echo "This script should be run via web browser, not command line.\n";
    exit(1);
}

// Set content type
header("Content-Type: text/html; charset=UTF-8");

// Officials settings to insert/update
$officials_settings = [
    // Chairman
    'chairmanFullName' => '',
    'chairmanEmail' => '',
    'chairmanPhone' => '',
    'chairmanProfilePhoto' => '',
    'chairmanTermStart' => '',
    'chairmanTermEnd' => '',
    'chairmanRoleDescription' => 'Leads the group and chairs all official meetings. Provides strategic direction and ensures the group operates in accordance with its constitution.',
    
    // Assistant Chairman
    'assistantChairmanFullName' => '',
    'assistantChairmanEmail' => '',
    'assistantChairmanPhone' => '',
    'assistantChairmanProfilePhoto' => '',
    'assistantChairmanTermStart' => '',
    'assistantChairmanTermEnd' => '',
    'assistantChairmanRoleDescription' => 'Supports the Chairman and assumes leadership responsibilities in the Chairman\'s absence. Assists in decision-making processes.',
    
    // Secretary
    'secretaryFullName' => '',
    'secretaryEmail' => '',
    'secretaryPhone' => '',
    'secretaryProfilePhoto' => '',
    'secretaryTermStart' => '',
    'secretaryTermEnd' => '',
    'secretaryRoleDescription' => 'Maintains official records, documents meeting minutes, and manages all correspondence. Ensures proper documentation of group activities.',
    
    // Organising Secretary
    'organisingSecretaryFullName' => '',
    'organisingSecretaryEmail' => '',
    'organisingSecretaryPhone' => '',
    'organisingSecretaryProfilePhoto' => '',
    'organisingSecretaryTermStart' => '',
    'organisingSecretaryTermEnd' => '',
    'organisingSecretaryRoleDescription' => 'Plans and coordinates group events, meetings, and activities. Manages logistics for all group functions and ensures smooth operations.',
    
    // Treasurer
    'treasurerFullName' => '',
    'treasurerEmail' => '',
    'treasurerPhone' => '',
    'treasurerProfilePhoto' => '',
    'treasurerTermStart' => '',
    'treasurerTermEnd' => '',
    'treasurerRoleDescription' => 'Manages all financial matters including contributions, expenses, and investments. Maintains accurate financial records and prepares reports.',
    
    // Loans Officer
    'loansOfficerFullName' => '',
    'loansOfficerEmail' => '',
    'loansOfficerPhone' => '',
    'loansOfficerProfilePhoto' => '',
    'loansOfficerTermStart' => '',
    'loansOfficerTermEnd' => '',
    'loansOfficerRoleDescription' => 'Oversees the loan application process, evaluates requests, and manages repayment schedules. Ensures responsible lending practices.'
];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Initialize Officials Settings - MFT GROUP</title>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: #1a1a1a;
            color: #fff;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .container {
            background: #2a2a2a;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        }
        h1 {
            color: #FF5C1B;
            text-align: center;
        }
        .settings-list {
            max-height: 400px;
            overflow-y: auto;
            background: #333;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .setting-item {
            padding: 8px 0;
            border-bottom: 1px solid #444;
        }
        .setting-item:last-child {
            border-bottom: none;
        }
        .actions {
            text-align: center;
            margin: 20px 0;
        }
        button {
            background: linear-gradient(135deg, #FF5C1B, #e05015);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            margin: 0 10px;
        }
        button:hover {
            background: linear-gradient(135deg, #e05015, #c2400f);
        }
        .result {
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            display: none;
        }
        .success {
            background: #28a745;
            display: block;
        }
        .error {
            background: #dc3545;
            display: block;
        }
        .warning {
            background: #ffc107;
            color: #000;
            display: block;
        }
        .status {
            text-align: center;
            font-weight: bold;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Initialize Officials Settings</h1>
        <p>This script will initialize the officials system settings for the MFT GROUP admin panel.</p>
        
        <h2>Officials Settings to be initialized (<?php echo count($officials_settings); ?> total):</h2>
        <div class="settings-list">
            <?php foreach ($officials_settings as $key => $value): ?>
                <div class="setting-item">
                    <strong><?php echo htmlspecialchars($key); ?></strong>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="actions">
            <button id="initSettings">Initialize Officials Settings</button>
            <button id="goToAdmin">Go to Admin Settings</button>
        </div>
        
        <div id="result" class="result"></div>
        <div id="status" class="status"></div>
    </div>

    <script>
        document.getElementById('initSettings').addEventListener('click', function() {
            const button = this;
            const originalText = button.innerHTML;
            button.innerHTML = 'Initializing...';
            button.disabled = true;
            
            const statusDiv = document.getElementById('status');
            const resultDiv = document.getElementById('result');
            
            // Send request to initialize officials settings
            fetch('api/init-officials-settings-api.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => {
                // Handle non-JSON responses (like error pages)
                const contentType = response.headers.get('content-type');
                if (!contentType || !contentType.includes('application/json')) {
                    return response.text().then(text => {
                        throw new Error('Server error: ' + text);
                    });
                }
                return response.json();
            })
            .then(data => {
                if (data.status === 'success') {
                    resultDiv.className = 'result success';
                    resultDiv.innerHTML = 'Officials settings initialized successfully! ' + data.message;
                } else {
                    resultDiv.className = 'result error';
                    resultDiv.innerHTML = 'Error: ' + (data.error || 'Unknown error');
                }
                statusDiv.innerHTML = 'Completed';
            })
            .catch(error => {
                resultDiv.className = 'result error';
                resultDiv.innerHTML = 'Error: ' + error.message;
                statusDiv.innerHTML = 'Failed';
                console.error('Fetch error:', error);
            })
            .finally(() => {
                button.innerHTML = originalText;
                button.disabled = false;
            });
        });
        
        document.getElementById('goToAdmin').addEventListener('click', function() {
            window.location.href = 'admin-settings.html';
        });
    </script>
</body>
</html>