# MFT GROUP Database Installation Guide

## Prerequisites

1. MySQL or MariaDB database server
2. PHP 7.4 or higher with PDO extension
3. Web server (Apache, Nginx, etc.)

## Database Setup

### 1. Create Database and User

Connect to your MySQL server and run the following commands:

```sql
CREATE DATABASE mft_group_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

CREATE USER 'mft_user'@'localhost' IDENTIFIED BY 'mft_password';

GRANT ALL PRIVILEGES ON mft_group_db.* TO 'mft_user'@'localhost';

FLUSH PRIVILEGES;
```

### 2. Import Database Schema

You can import the schema in two ways:

#### Option A: Using the initialization script (Recommended)

Run the initialization script from the command line:

```bash
cd /path/to/mft/database
php init_db.php
```

#### Option B: Manual import

Import the schema file directly into your database:

```bash
mysql -u mft_user -p mft_group_db < mft_database_schema.sql
```

### 3. Configure Database Connection

Edit the `config.php` file to match your database settings:

```php
// Database configuration
define('DB_HOST', 'localhost');        // Your database host
define('DB_NAME', 'mft_group_db');     // Your database name
define('DB_USER', 'mft_user');         // Your database user
define('DB_PASS', 'mft_password');     // Your database password
define('DB_CHARSET', 'utf8mb4');       // Character set
```

## API Setup

### 1. Web Server Configuration

Ensure your web server is configured to serve PHP files and that the API directory is accessible.

### 2. Test API Endpoints

After setup, you can test the API endpoints:

- `GET /api/members.php` - Get all members
- `GET /api/members.php?id=1` - Get specific member
- `GET /api/contributions.php` - Get all contributions
- `GET /api/loans.php` - Get all loans
- `GET /api/dashboard.php?type=admin` - Get admin dashboard data

## File Structure

```
/database/
  ├── config.php              # Database configuration
  ├── mft_database_schema.sql # Database schema
  ├── init_db.php            # Database initialization script
  ├── README.md              # Database documentation
  └── INSTALL.md             # This file

/api/
  ├── members.php            # Members API
  ├── contributions.php      # Contributions API
  ├── loans.php              # Loans API
  └── dashboard.php          # Dashboard API

/js/
  └── api-client.js          # JavaScript API client
```

## Security Considerations

1. **Change Default Credentials**: Update the default database username and password in `config.php`
2. **File Permissions**: Ensure sensitive files are not directly accessible via web server
3. **Input Validation**: All API endpoints validate input data
4. **SQL Injection Protection**: All database queries use prepared statements
5. **CORS Headers**: Configured for controlled cross-origin access

## Troubleshooting

### Common Issues

1. **Database Connection Failed**
   - Check database credentials in `config.php`
   - Ensure MySQL service is running
   - Verify database and user exist

2. **Permission Denied**
   - Check file permissions for PHP files
   - Ensure web server can read files

3. **API Endpoints Not Found**
   - Check web server configuration
   - Ensure URL rewriting is properly configured

### Testing Database Connection

You can test the database connection by running:

```bash
php -r "require_once 'config.php'; \$pdo = getDatabaseConnection(); echo 'Connection successful';"
```

## Sample Data

The database schema includes sample data for testing:
- Default admin user
- Sample members
- Sample contributions
- Sample loan

This data is for development and testing purposes only.

## Maintenance

### Backup

Regularly backup your database:

```bash
mysqldump -u mft_user -p mft_group_db > backup_$(date +%Y%m%d).sql
```

### Updates

To update the database schema:
1. Backup your current database
2. Apply schema changes incrementally
3. Test all functionality after updates

## Support

For issues with the database setup, please check:
1. Database server logs
2. PHP error logs
3. Web server error logs