<!DOCTYPE html>
<html>
<head>
    <title>Create and Approve Test Loan</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .container { max-width: 800px; margin: 0 auto; }
        .result { background: #f0f0f0; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; }
        button { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        button:hover { background: #0056b3; }
    </style>
</head>
<body>
<div class="container">
    <h1>Create and Approve Test Loan</h1>
    
    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        require_once 'database/config.php';
        
        try {
            $pdo = getDatabaseConnection();
            
            // Get an active member
            $member_stmt = $pdo->prepare("SELECT id, member_id, first_name, last_name FROM members WHERE status = 'Active' LIMIT 1");
            $member_stmt->execute();
            $member = $member_stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$member) {
                echo "<div class='result error'>No active members found.</div>";
                exit;
            }
            
            echo "<div class='result'>Using member: " . htmlspecialchars($member['member_id']) . " (" . htmlspecialchars($member['first_name'] . " " . $member['last_name']) . ")</div>";
            
            // Generate unique reference
            $reference = "LOAN-WEB-" . date('YmdHis') . "-" . strtoupper(substr(md5(uniqid()), 0, 4));
            
            // Create test loan
            $insert_stmt = $pdo->prepare("INSERT INTO loans (reference, member_id, loan_type, principal_amount, interest_rate, total_amount, repayment_period, monthly_payment, purpose, application_date, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            $result = $insert_stmt->execute([
                $reference,
                $member['id'],
                'Emergency',
                7500.00,
                12.00,
                8400.00,
                8,
                1050.00,
                'Web test loan for agreement verification',
                date('Y-m-d'),
                'Pending'
            ]);
            
            if ($result) {
                $loan_id = $pdo->lastInsertId();
                echo "<div class='result success'>Created loan ID: $loan_id with reference: $reference</div>";
                
                // Get admin user
                $admin_stmt = $pdo->prepare("SELECT id, member_id FROM members WHERE member_id LIKE 'ADM-%' LIMIT 1");
                $admin_stmt->execute();
                $admin = $admin_stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($admin) {
                    echo "<div class='result'>Approving with admin: " . htmlspecialchars($admin['member_id']) . "</div>";
                    
                    // Approve the loan through the API function to trigger agreement generation
                    // Include the loans API
                    require_once 'api/loans.php';
                    
                    // Prepare update data
                    $update_data = [
                        'status' => 'Approved',
                        'approval_date' => date('Y-m-d'),
                        'approved_by' => $admin['member_id']  // Use member reference ID
                    ];
                    
                    // Call the update function
                    ob_start();
                    updateLoan($loan_id, $update_data);
                    $api_response = ob_get_clean();
                    
                    $response_data = json_decode($api_response, true);
                    
                    if ($response_data && isset($response_data['message'])) {
                        echo "<div class='result success'>Loan approval response: " . htmlspecialchars($response_data['message']) . "</div>";
                        
                        // Check for the agreement file
                        $expected_filename = 'loan_agreement_' . $reference . '_' . date('Y-m-d') . '.pdf';
                        $expected_path = 'documents/loan_agreements/' . $expected_filename;
                        
                        echo "<div class='result'>Checking for agreement at: $expected_path</div>";
                        
                        if (file_exists($expected_path)) {
                            echo "<div class='result success'>SUCCESS: Loan agreement generated!</div>";
                            echo "<div class='result'>File: <a href='$expected_path' target='_blank'>$expected_path</a></div>";
                            echo "<div class='result'>Size: " . filesize($expected_path) . " bytes</div>";
                        } else {
                            // Check in the directory for any recent files
                            $files = glob('documents/loan_agreements/*.pdf');
                            if (!empty($files)) {
                                $latest_file = $files[count($files) - 1];
                                echo "<div class='result success'>SUCCESS: Loan agreement found at: <a href='$latest_file' target='_blank'>$latest_file</a></div>";
                            } else {
                                echo "<div class='result error'>Loan agreement not found in expected location.</div>";
                            }
                        }
                    } else {
                        echo "<div class='result error'>Error approving loan. API Response: " . htmlspecialchars($api_response) . "</div>";
                    }
                } else {
                    echo "<div class='result error'>No admin user found.</div>";
                }
            } else {
                echo "<div class='result error'>Failed to create loan.</div>";
            }
        } catch (Exception $e) {
            echo "<div class='result error'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
        }
    } else {
    ?>
        <form method="POST">
            <p>This script will:</p>
            <ol>
                <li>Create a test loan for an active member</li>
                <li>Approve the loan using the admin API</li>
                <li>Trigger automatic loan agreement generation</li>
                <li>Verify that the agreement PDF was created</li>
            </ol>
            <button type="submit">Create and Approve Test Loan</button>
        </form>
    <?php } ?>
</div>
</body>
</html>