<?php
// Check members table structure
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    echo "Database connection successful!\n";
    
    // Show members table structure
    $stmt = $pdo->prepare("DESCRIBE members");
    $stmt->execute();
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Members table structure:\n";
    foreach ($columns as $column) {
        echo "- " . $column['Field'] . " (" . $column['Type'] . ")\n";
    }
    
    // Check if profile_photo column exists
    $hasProfilePhoto = false;
    foreach ($columns as $column) {
        if ($column['Field'] === 'profile_photo') {
            $hasProfilePhoto = true;
            break;
        }
    }
    
    if (!$hasProfilePhoto) {
        echo "\nprofile_photo column does not exist in members table.\n";
        echo "Need to add it with: ALTER TABLE members ADD COLUMN profile_photo VARCHAR(255) NULL;\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>