<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check the structure of the loans table
    $sql = "DESCRIBE loans";
    $stmt = $pdo->query($sql);
    $columns = $stmt->fetchAll();
    
    echo "Loans table structure:\n";
    foreach ($columns as $column) {
        echo "- " . $column['Field'] . " (" . $column['Type'] . ")\n";
    }
    
    echo "\nChecking for specific columns:\n";
    $requiredColumns = ['loan_type', 'total_amount', 'repayment_period', 'guarantor_id', 'guarantor_approval_status', 'is_topup_loan'];
    foreach ($requiredColumns as $column) {
        $exists = false;
        foreach ($columns as $col) {
            if ($col['Field'] == $column) {
                $exists = true;
                break;
            }
        }
        echo "- $column: " . ($exists ? "EXISTS" : "MISSING") . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>