<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check the structure of the loans table
    $stmt = $pdo->query("DESCRIBE loans");
    $columns = $stmt->fetchAll();
    
    echo "Loans table structure:\n";
    echo str_repeat("-", 40) . "\n";
    foreach ($columns as $column) {
        echo sprintf("%-20s %-20s\n", $column['Field'], $column['Type']);
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>