<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check how many loans exist
    $sql = "SELECT COUNT(*) as count FROM loans";
    $stmt = $pdo->query($sql);
    $result = $stmt->fetch();
    echo "Total loans in database: " . $result['count'] . "\n";
    
    // Check if there are any loans with invalid data
    if ($result['count'] > 0) {
        echo "\nSample loans:\n";
        $sql = "SELECT id, reference, member_id, loan_type, principal_amount, status FROM loans LIMIT 5";
        $stmt = $pdo->query($sql);
        $loans = $stmt->fetchAll();
        
        foreach ($loans as $loan) {
            echo "- ID: " . $loan['id'] . ", Ref: " . $loan['reference'] . ", Member ID: " . $loan['member_id'] . ", Type: " . $loan['loan_type'] . ", Amount: " . $loan['principal_amount'] . ", Status: " . $loan['status'] . "\n";
        }
    }
    
    // Check if there are any members
    $sql = "SELECT COUNT(*) as count FROM members";
    $stmt = $pdo->query($sql);
    $result = $stmt->fetch();
    echo "\nTotal members in database: " . $result['count'] . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>