<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check if member_projects table exists and its structure
    $stmt = $pdo->query("DESCRIBE member_projects");
    $columns = $stmt->fetchAll();
    
    echo "member_projects table structure:\n";
    foreach ($columns as $column) {
        echo "- " . $column['Field'] . " (" . $column['Type'] . ")\n";
    }
    
    // Check if projects table exists and its structure
    $stmt = $pdo->query("DESCRIBE projects");
    $columns = $stmt->fetchAll();
    
    echo "\nprojects table structure:\n";
    foreach ($columns as $column) {
        echo "- " . $column['Field'] . " (" . $column['Type'] . ")\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>