<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    echo "Database connection successful!\n";
    
    // Check if tables exist
    $stmt = $pdo->query("SHOW TABLES LIKE 'member_projects'");
    $tableExists = $stmt->fetch();
    
    if ($tableExists) {
        echo "member_projects table exists\n";
        
        // Check structure
        $stmt = $pdo->query("DESCRIBE member_projects");
        $columns = $stmt->fetchAll();
        
        echo "Columns in member_projects:\n";
        foreach ($columns as $column) {
            echo "- " . $column['Field'] . " (" . $column['Type'] . ")\n";
        }
    } else {
        echo "member_projects table does not exist\n";
    }
    
    // Check projects table
    $stmt = $pdo->query("SHOW TABLES LIKE 'projects'");
    $tableExists = $stmt->fetch();
    
    if ($tableExists) {
        echo "\nprojects table exists\n";
    } else {
        echo "\nprojects table does not exist\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>