<!DOCTYPE html>
<html>
<head>
    <title>Check All Files in Documents Directory</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .container { max-width: 800px; margin: 0 auto; }
        .result { background: #f0f0f0; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; }
        .file-list { margin: 15px 0; }
        .file-item { padding: 5px 0; border-bottom: 1px solid #eee; }
        .subdir { margin-left: 20px; }
    </style>
</head>
<body>
<div class="container">
    <h1>All Files in Documents Directory</h1>
    
    <?php
    function listDirectory($dir, $level = 0) {
        if (!is_dir($dir)) {
            echo "<div class='result error'>Directory does not exist: $dir</div>";
            return;
        }
        
        $files = scandir($dir);
        
        if ($level == 0) {
            echo "<div class='result success'>Directory: $dir</div>";
        }
        
        echo "<div class='file-list'>";
        
        foreach ($files as $file) {
            if ($file == '.' || $file == '..') continue;
            
            $path = $dir . '/' . $file;
            $indent = str_repeat("&nbsp;", $level * 4);
            
            if (is_dir($path)) {
                echo "<div class='file-item'><strong>{$indent}[DIR] $file</strong></div>";
                listDirectory($path, $level + 1);
            } else {
                $filesize = filesize($path);
                $modtime = date("Y-m-d H:i:s", filemtime($path));
                echo "<div class='file-item'>{$indent}<a href='$path' target='_blank'>$file</a> (" . number_format($filesize) . " bytes, $modtime)</div>";
            }
        }
        
        echo "</div>";
    }
    
    // Check main documents directory
    listDirectory('documents');
    
    // Also check if the loan agreement function might be saving elsewhere
    echo "<h2>Checking for Loan Agreement Function</h2>";
    
    if (file_exists('api/loan-agreement-generator.php')) {
        echo "<div class='result success'>Found loan agreement generator: api/loan-agreement-generator.php</div>";
        
        // Let's look at where the function saves files
        $content = file_get_contents('api/loan-agreement-generator.php');
        if (strpos($content, 'documents/loan_agreements') !== false) {
            echo "<div class='result'>Found reference to documents/loan_agreements in generator</div>";
        }
        
        // Try to find the save path in the dompdf-utils.php
        if (file_exists('api/dompdf-utils.php')) {
            $dompdf_content = file_get_contents('api/dompdf-utils.php');
            echo "<div class='result'>Checking dompdf-utils.php for save path...</div>";
        }
    } else {
        echo "<div class='result error'>Loan agreement generator not found</div>";
    }
    ?>
</div>
</body>
</html>