<!DOCTYPE html>
<html>
<head>
    <title>Check Loan Agreements</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .container { max-width: 800px; margin: 0 auto; }
        .result { background: #f0f0f0; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; }
        .file-list { margin: 15px 0; }
        .file-item { padding: 5px 0; border-bottom: 1px solid #eee; }
    </style>
</head>
<body>
<div class="container">
    <h1>Loan Agreements in Directory</h1>
    
    <?php
    $directory = 'documents/loan_agreements';
    
    if (is_dir($directory)) {
        echo "<div class='result success'>Directory exists: $directory</div>";
        
        // Get all PDF files in the directory
        $files = glob("$directory/*.pdf");
        
        if (!empty($files)) {
            echo "<div class='result'>Found " . count($files) . " PDF files:</div>";
            echo "<div class='file-list'>";
            
            // Sort files by modification time (newest first)
            usort($files, function($a, $b) {
                return filemtime($b) - filemtime($a);
            });
            
            foreach ($files as $file) {
                $filename = basename($file);
                $filesize = filesize($file);
                $modtime = date("F j, Y, g:i a", filemtime($file));
                
                echo "<div class='file-item'>";
                echo "<strong><a href='$file' target='_blank'>$filename</a></strong><br>";
                echo "Size: " . number_format($filesize) . " bytes<br>";
                echo "Modified: $modtime";
                echo "</div>";
            }
            
            echo "</div>";
        } else {
            echo "<div class='result error'>No PDF files found in directory.</div>";
        }
    } else {
        echo "<div class='result error'>Directory does not exist: $directory</div>";
        
        // Try to create the directory
        if (mkdir($directory, 0777, true)) {
            echo "<div class='result success'>Created directory: $directory</div>";
        } else {
            echo "<div class='result error'>Failed to create directory: $directory</div>";
        }
    }
    ?>
    
    <h2>Refresh Page</h2>
    <p>Click the button below to refresh and check for new agreements:</p>
    <form method="GET">
        <button type="submit">Refresh File List</button>
    </form>
</div>
</body>
</html>