<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check if there are any members with admin roles
    $sql = "SELECT m.id, m.member_id, m.first_name, m.last_name, m.email, m.role, 
                   mr.role_id, r.name as role_name
            FROM members m
            JOIN member_roles mr ON m.id = mr.member_id
            JOIN roles r ON mr.role_id = r.id
            WHERE r.name IN ('Admin', 'Treasurer', 'Secretary', 'Chairman', 'Assistant Chairman', 'Assistant Secretary', 'Loans Officer')
            ORDER BY m.created_at DESC";
    
    $stmt = $pdo->query($sql);
    $admins = $stmt->fetchAll();
    
    echo "Admin Users in Database:\n";
    echo str_repeat("-", 50) . "\n";
    
    if (empty($admins)) {
        echo "No admin users found in the database.\n";
        echo "This could explain why admins are missing in admins.html\n\n";
        
        // Check if there are any members at all
        $memberSql = "SELECT COUNT(*) as count FROM members";
        $memberStmt = $pdo->query($memberSql);
        $memberCount = $memberStmt->fetch();
        
        echo "Total members in database: " . $memberCount['count'] . "\n";
        
        // Check if there are any roles
        $roleSql = "SELECT * FROM roles";
        $roleStmt = $pdo->query($roleSql);
        $roles = $roleStmt->fetchAll();
        
        echo "\nAvailable roles:\n";
        foreach ($roles as $role) {
            echo "- " . $role['name'] . " (ID: " . $role['id'] . ")\n";
        }
    } else {
        foreach ($admins as $admin) {
            echo "ID: " . $admin['id'] . " | Name: " . $admin['first_name'] . " " . $admin['last_name'] . " | Role: " . $admin['role_name'] . "\n";
        }
        echo "\nTotal admin users: " . count($admins) . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>