<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check if admin_access_codes table exists and has data
    $sql = "SELECT * FROM admin_access_codes";
    $stmt = $pdo->query($sql);
    $codes = $stmt->fetchAll();
    
    echo "Access codes found: " . count($codes) . "\n";
    
    if (count($codes) > 0) {
        echo "Access codes:\n";
        foreach ($codes as $code) {
            echo "- Member ID: " . $code['member_id'] . ", Code: " . $code['access_code'] . "\n";
        }
    } else {
        echo "No access codes found in the table.\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>