<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Get all access codes and their associated members
    $sql = "SELECT aac.access_code, m.id as member_id, m.member_id as member_ref, 
                   CONCAT(m.first_name, ' ', m.last_name) as member_name
            FROM admin_access_codes aac
            JOIN members m ON aac.member_id = m.id
            ORDER BY m.id";
    
    $stmt = $pdo->query($sql);
    $accessCodes = $stmt->fetchAll();
    
    echo "Existing Access Codes:\n";
    echo str_repeat("-", 50) . "\n";
    foreach ($accessCodes as $code) {
        echo "Code: " . $code['access_code'] . " | Member ID: " . $code['member_id'] . " | Member: " . $code['member_name'] . "\n";
    }
    
    if (empty($accessCodes)) {
        echo "No access codes found in the database.\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>