<?php
// MFT GROUP Update Trigger Example
// This script demonstrates how to trigger real-time updates when data changes

// Include necessary files
require_once __DIR__ . '/../database/config.php';
require_once '../js/notification-service.js'; // This won't work directly, just for example

// Example function to trigger update after adding a contribution
function triggerContributionUpdate($memberId, $contributionId, $amount) {
    // In a real implementation, you would call the notification service
    // For now, we'll just log the update
    
    error_log("Contribution update triggered: Member $memberId, Contribution $contributionId, Amount $amount");
    
    // Example of what you would do in a real implementation:
    /*
    $notificationService = new MFTNotificationService();
    $notificationService->notifyContributionUpdate($memberId, $contributionId, [
        'amount' => $amount,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    */
    
    return true;
}

// Example function to trigger update after adding a loan
function triggerLoanUpdate($memberId, $loanId, $amount) {
    error_log("Loan update triggered: Member $memberId, Loan $loanId, Amount $amount");
    
    return true;
}

// Example function to trigger dashboard update
function triggerDashboardUpdate($dashboardType) {
    error_log("Dashboard update triggered: $dashboardType");
    
    return true;
}

// Example usage in your existing API endpoints:

// In contributions.php, after successfully adding a contribution:
/*
if ($contribution_id = addContribution($contribution_data)) {
    triggerContributionUpdate($member_id, $contribution_id, $contribution_data['amount']);
    // Return success response
}
*/

// In loans.php, after successfully adding a loan:
/*
if ($loan_id = addLoan($loan_data)) {
    triggerLoanUpdate($member_id, $loan_id, $loan_data['principal_amount']);
    // Return success response
}
*/

// Sample endpoint to manually trigger updates (for testing)
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid JSON data']);
        exit;
    }
    
    $updateType = isset($input['type']) ? $input['type'] : '';
    
    switch ($updateType) {
        case 'contribution':
            $memberId = isset($input['member_id']) ? $input['member_id'] : 0;
            $amount = isset($input['amount']) ? $input['amount'] : 0;
            triggerContributionUpdate($memberId, time(), $amount);
            http_response_code(200);
            echo json_encode(['status' => 'success', 'message' => 'Contribution update triggered']);
            break;
            
        case 'loan':
            $memberId = isset($input['member_id']) ? $input['member_id'] : 0;
            $amount = isset($input['amount']) ? $input['amount'] : 0;
            triggerLoanUpdate($memberId, time(), $amount);
            http_response_code(200);
            echo json_encode(['status' => 'success', 'message' => 'Loan update triggered']);
            break;
            
        case 'dashboard':
            $dashboardType = isset($input['dashboard_type']) ? $input['dashboard_type'] : 'admin';
            triggerDashboardUpdate($dashboardType);
            http_response_code(200);
            echo json_encode(['status' => 'success', 'message' => 'Dashboard update triggered']);
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['error' => 'Invalid update type']);
            break;
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
}
?>