<?php
// MFT GROUP Notification Service API
// This script handles real-time notifications between back office and front office

require_once __DIR__ . '/../database/config.php';
require_once __DIR__ . '/notification-service-class.php';

// API endpoint for notifications
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    handleGetNotifications();
} else if ($method === 'POST') {
    handleSendNotification();
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
}

function handleGetNotifications() {
    try {
        $notificationService = new MFTNotificationService();
        
        $target = isset($_GET['target']) ? $_GET['target'] : 'all';
        $memberId = isset($_GET['member_id']) ? intval($_GET['member_id']) : null;
        $lastCheck = isset($_GET['last_check']) ? intval($_GET['last_check']) : 0;
        
        $notifications = $notificationService->getNotifications($target, $memberId, $lastCheck);
        
        echo json_encode([
            'status' => 'success',
            'notifications' => $notifications,
            'count' => count($notifications)
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to get notifications: ' . $e->getMessage()]);
    }
}

function handleSendNotification() {
    try {
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid JSON data']);
            return;
        }
        
        $notificationService = new MFTNotificationService();
        
        $type = isset($input['type']) ? $input['type'] : '';
        $data = isset($input['data']) ? $input['data'] : [];
        $target = isset($input['target']) ? $input['target'] : 'all';
        $memberId = isset($input['member_id']) ? intval($input['member_id']) : null;
        
        if (empty($type)) {
            http_response_code(400);
            echo json_encode(['error' => 'Notification type is required']);
            return;
        }
        
        $result = $notificationService->sendNotification($type, $data, $target, $memberId);
        
        if ($result) {
            echo json_encode(['status' => 'success', 'message' => 'Notification sent']);
        } else {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to send notification']);
        }
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to send notification: ' . $e->getMessage()]);
    }
}
?>