<!DOCTYPE html>

<html lang="en">

<head>

<meta charset="UTF-8">

<title>Loan Agreement - <?= $loanRef ?></title>



<style>

  body {

    font-family: 'DejaVu Sans', sans-serif;

    font-size: 11pt;

    line-height: 1.6;

    color: #222;

    margin: 30px;

  }



  h1, h2, h3 {

    color: #0f3b62;

    margin-bottom: 5px;

  }



  /* ===== Header / Letterhead ===== */

  .header {

    text-align: center;

    border-bottom: 3px solid #0f3b62;

    padding-bottom: 10px;

    margin-bottom: 25px;

  }



  .header h1 {

    font-size: 20pt;

    letter-spacing: 0.5px;

    margin-bottom: 2px;

  }



  .meta {

    font-size: 10pt;

    color: #444;

  }



  /* ===== Section Titles ===== */

  .section-title {

    color: #0f3b62;

    font-weight: bold;

    text-transform: uppercase;

    border-bottom: 1px solid #cfd8e3;

    margin-top: 25px;

    padding-bottom: 3px;

  }



  /* ===== Tables ===== */

  table {

    width: 100%;

    border-collapse: collapse;

    margin-top: 8px;

    margin-bottom: 15px;

  }



  th, td {

    border: 1px solid #ccc;

    padding: 8px;

  }



  th {

    background: #eef3f8;

    color: #0f3b62;

    text-align: left;

  }



  /* ===== Signature Section ===== */

  .signatures {

    margin-top: 40px;

  }



  .signature-block {

    width: 48%;

    display: inline-block;

    vertical-align: top;

  }



  .sign-line {

    border-top: 1px solid #000;

    width: 100%;

    margin-top: 40px;

  }



  .qr-section {

    text-align: center;

    margin-top: 40px;

    font-size: 10pt;

  }



  .qr-section img {

    width: 90px;

    height: 90px;

    margin-top: 5px;

  }



  /* Replace footer with div to avoid Dompdf issues */
  .footer {
    position: fixed;
    bottom: 10px;
    left: 0;
    right: 0;
    text-align: center;
    font-size: 9pt;
    color: #666;
  }



  .page-number:before {

    content: "Page " counter(page) " of " counter(pages);

  }



</style>

</head>



<body>



<div class="header">

  <h1>LOAN AGREEMENT</h1>

  <div class="meta">

    Loan Reference: <strong><?= $loanRef ?></strong> |

    Agreement Date: <strong><?= $agreementDate ?></strong>

  </div>

</div>



<div class="section-title">Parties to the Agreement</div>

<p>

  This Loan Agreement is made on <strong><?= $agreementDate ?></strong> between:

</p>

<p>

  <strong><?= $lenderName ?></strong> (hereinafter referred to as "the Lender"), a registered

  self-help group with registration number <strong>DSD/22/120/01/78701</strong>, having its

  principal office at <strong><?= $lenderAddress ?></strong>.

</p>

<p>

  AND <strong><?= $borrowerName ?></strong> (hereinafter referred to as "the Borrower"),

  Membership No. <strong><?= str_pad($borrowerMemberNo, 9, 'MFT0', STR_PAD_LEFT) ?></strong>, ID No. <strong><?= $borrowerId ?></strong>,

  residing at <strong><?= $borrowerAddress ?></strong>.

</p>



<div class="section-title">Loan Details</div>

<table>

  <tr><th>Loan Type</th><td><?= $loanType ?></td></tr>

  <tr><th>Purpose</th><td><?= $loanPurpose ?></td></tr>

  <tr><th>Principal Amount</th><td>KES <?= number_format($principalAmount, 2) ?></td></tr>

  <tr><th>Interest Rate</th><td><?= $interestRate ?>% per month</td></tr>

  <tr><th>Total Amount</th><td>KES <?= number_format($totalAmount, 2) ?></td></tr>

  <tr><th>Repayment Period</th><td><?= $repaymentPeriod ?> months</td></tr>

  <tr><th>Monthly Payment</th><td>KES <?= number_format($monthlyPayment, 2) ?></td></tr>

  <tr><th>Application Date</th><td><?= $applicationDate ?></td></tr>

  <tr><th>Approval Date</th><td><?= $approvalDate ?></td></tr>

  <tr><th>Disbursement Date</th><td><?= $disbursementDate ?: 'N/A' ?></td></tr>

  <tr><th>First Payment Date</th><td><?= $firstPaymentDate ?: 'N/A' ?></td></tr>

</table>



<div class="section-title">Terms and Conditions</div>

<p>

  The Borrower agrees to repay the loan amount of <strong>KES <?= number_format($totalAmount, 2) ?></strong>

  in <strong><?= $repaymentPeriod ?></strong> monthly installments of

  <strong>KES <?= number_format($monthlyPayment, 2) ?></strong>. Interest is charged at

  <strong><?= $interestRate ?>%</strong> per month on the reducing balance.

</p>



<ul>

  <li>All payments shall be made in Kenyan Shillings (KES) to the Lender's designated account.</li>

  <li>Late payments will attract a penalty of 2% per month on the overdue amount.</li>

  <li>The Borrower shall maintain membership in good standing throughout the loan period.</li>

  <li>The Lender reserves the right to demand immediate repayment if the Borrower defaults on two consecutive payments.</li>

  <li>This agreement shall be governed by the laws of the Republic of Kenya.</li>

  <li>Any disputes shall be resolved through the Lender's internal dispute resolution mechanism.</li>

</ul>



<div class="section-title">Payment Schedule</div>

<table>

  <tr>

    <th>Installment</th>

    <th>Due Date</th>

    <th>Principal (KES)</th>

    <th>Interest (KES)</th>

    <th>Total Payment (KES)</th>

    <th>Balance (KES)</th>

  </tr>

  <?php foreach ($schedule as $s): ?>

  <tr>

    <td><?= $s['number'] ?></td>

    <td><?= $s['date'] ?></td>

    <td><?= number_format($s['principal'], 2) ?></td>

    <td><?= number_format($s['interest'], 2) ?></td>

    <td><?= number_format($s['total'], 2) ?></td>

    <td><?= number_format($s['balance'], 2) ?></td>

  </tr>

  <?php endforeach; ?>

</table>



<div class="section-title">Borrower Signature</div>
<div class="signature-block">
  <?php if(!empty($borrowerSignature)): ?>
    <img src="<?= $borrowerSignature ?>" width="120" alt="Borrower Signature"><br>
  <?php else: ?>
    <div class="sign-line"></div>
  <?php endif; ?>
  <strong>Name:</strong> <?= $borrowerName ?><br>
  <strong>ID Number:</strong> <?= $borrowerId ?><br>
  <strong>Phone:</strong> <?= $borrowerPhone ?><br>
  <strong>Date:</strong> <?= $agreementDate ?><br>
</div>

<div class="section-title">Lender Signature</div>
<div class="signature-block">
  <?php if(!empty($lenderSignature)): ?>
    <img src="<?= $lenderSignature ?>" width="120" alt="Lender Signature"><br>
  <?php else: ?>
    <div class="sign-line"></div>
  <?php endif; ?>
  <strong>Organization:</strong> <?= $lenderName ?><br>
  <strong>Registration:</strong> <?= $lenderRegNo ?><br>
  <strong>Representative:</strong> <?= $lenderRep ?><br>
  <strong>Date:</strong> <?= $agreementDate ?><br>
</div>



<div class="qr-section">

  <p><strong>Verification Code:</strong> <?= $loanRef ?></p>
  <?php if (!empty($qrCode)): ?>
    <img src="<?= $qrCode ?>" alt="QR Code"><br>
  <?php else: ?>
    <div>[QR Code would appear here]</div>
  <?php endif; ?>
  Scan this code to verify authenticity:<br>

  <strong><?= $verificationUrl ?></strong>

</div>



<p style="margin-top: 40px; font-size: 10pt; color: #555;">

  This is a legally binding document. Both parties acknowledge that they have read,

  understood, and agreed to all terms and conditions.

</p>



<!-- Replace footer with div to avoid Dompdf issues -->
<div class="footer">
  <span class="page-number"></span><br>
  Generated on <?= date('F j, Y, g:i A') ?> by <?= $lenderName ?> MFT SELF HELP GROUP Financial System.

</div>



</body>

</html>