<?php
// Initialize Banking Settings API
// This script initializes default banking settings in the database

// Enable CORS for frontend access
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Include database configuration
require_once __DIR__ . '/../database/config.php';

try {
    // Default banking settings
    $bankingSettings = [
        [
            'setting_key' => 'bank_primary_name',
            'setting_value' => 'Kingdom Bank',
            'description' => 'Primary bank name'
        ],
        [
            'setting_key' => 'bank_primary_account_number',
            'setting_value' => '3061803729002',
            'description' => 'Primary bank account number'
        ],
        [
            'setting_key' => 'bank_primary_account_name',
            'setting_value' => 'MFT GROUP',
            'description' => 'Primary bank account name'
        ],
        [
            'setting_key' => 'bank_primary_branch',
            'setting_value' => 'Kikuyu Branch',
            'description' => 'Primary bank branch'
        ],
        [
            'setting_key' => 'bank_primary_swift_code',
            'setting_value' => 'CIFIKENAXXX',
            'description' => 'Primary bank SWIFT code'
        ],
        [
            'setting_key' => 'mpesa_paybill_number',
            'setting_value' => '123456',
            'description' => 'M-Pesa Paybill number'
        ],
        [
            'setting_key' => 'mpesa_account_number',
            'setting_value' => 'MFT',
            'description' => 'M-Pesa account number'
        ],
        [
            'setting_key' => 'account_visibility',
            'setting_value' => 'public',
            'description' => 'Bank account visibility setting'
        ]
    ];

    try {
        beginTransaction();
        
        $insertedCount = 0;
        foreach ($bankingSettings as $setting) {
            // Check if setting already exists
            $checkSql = "SELECT id FROM system_settings WHERE setting_key = ?";
            $existing = fetchSingleRow($checkSql, [$setting['setting_key']]);
            
            if (!$existing) {
                // Insert setting
                $sql = "INSERT INTO system_settings (setting_key, setting_value, description) VALUES (?, ?, ?)";
                executeNonQuery($sql, [$setting['setting_key'], $setting['setting_value'], $setting['description']]);
                $insertedCount++;
            }
        }
        
        commitTransaction();
        
        http_response_code(200);
        echo json_encode([
            'status' => 'success',
            'message' => "Banking settings initialized successfully. $insertedCount new settings added.",
            'settings' => $bankingSettings
        ]);
        
    } catch (Exception $e) {
        rollbackTransaction();
        throw $e;
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to initialize banking settings: ' . $e->getMessage()
    ]);
}
?>