<?php
// MFT GROUP Admin Permissions API
// This API provides admin module permission management functionality

// Enable CORS for frontend access
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database configuration
require_once __DIR__ . '/../database/config.php';

// Get request method
$method = $_SERVER['REQUEST_METHOD'];

// DISABLED: All admin role-based permissions are now disabled
// Return full access for all modules regardless of stored permissions

try {
    switch ($method) {
        case 'GET':
            handleGetRequest();
            break;
        case 'POST':
        case 'PUT':
            handlePostPutRequest();
            break;
        case 'DELETE':
            handleDeleteRequest();
            break;
        default:
            http_response_code(405);
            echo json_encode(['error' => 'Method not allowed']);
            break;
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Internal server error: ' . $e->getMessage()]);
}

function handleGetRequest() {
    if (isset($_GET['member_id'])) {
        // DISABLED: Return full access for all modules
        $modules = ['dashboard', 'members', 'contributions', 'loans', 'fines', 'projects', 'meetings', 'documents', 'audit', 'expenses', 'settings'];
        $permissions = [];
        foreach ($modules as $module) {
            $permissions[$module] = 'full';
        }
        
        http_response_code(200);
        echo json_encode([
            'member_id' => $_GET['member_id'],
            'permissions' => $permissions
        ]);
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Member ID is required']);
    }
}

function handlePostPutRequest() {
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid JSON data']);
        return;
    }
    
    // Check if member_id is provided
    if (!isset($input['member_id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Member ID is required']);
        return;
    }
    
    // DISABLED: Don't actually save permissions, just return success
    http_response_code(200);
    echo json_encode(['message' => 'Permissions saved successfully']);
}

function handleDeleteRequest() {
    if (!isset($_GET['member_id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Member ID is required']);
        return;
    }
    
    // DISABLED: Don't actually delete permissions, just return success
    http_response_code(200);
    echo json_encode(['message' => 'Permissions deleted successfully']);
}

// DISABLED: Original functions are commented out
/*
function getMemberPermissions($memberId) {
    try {
        // Validate member ID
        if (empty($memberId)) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid member ID']);
            return;
        }
        
        // Get all permissions for this member
        $sql = "SELECT module_name, access_level FROM admin_module_permissions WHERE member_id = ?";
        $permissions = executeQuery($sql, [$memberId]);
        
        // Check if query executed successfully
        if ($permissions === false) {
            throw new Exception("Failed to execute database query");
        }
        
        // Format permissions as an associative array
        $formattedPermissions = [];
        foreach ($permissions as $permission) {
            $formattedPermissions[$permission['module_name']] = $permission['access_level'];
        }
        
        http_response_code(200);
        echo json_encode([
            'member_id' => $memberId,
            'permissions' => $formattedPermissions
        ]);
    } catch (Exception $e) {
        error_log("Error retrieving permissions for member ID $memberId: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => 'Failed to retrieve permissions: ' . $e->getMessage()]);
    }
}

function saveMemberPermissions($memberId, $permissions) {
    try {
        // Validate member ID
        if (empty($memberId)) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid member ID']);
            return;
        }
        
        beginTransaction();
        
        // Delete existing permissions for this member
        $deleteSql = "DELETE FROM admin_module_permissions WHERE member_id = ?";
        $deleteResult = executeNonQuery($deleteSql, [$memberId]);
        
        // Check if deletion was successful
        if ($deleteResult === false) {
            throw new Exception("Failed to delete existing permissions");
        }
        
        // Insert new permissions
        if (is_array($permissions)) {
            $insertSql = "INSERT INTO admin_module_permissions (member_id, module_name, access_level) VALUES (?, ?, ?)";
            foreach ($permissions as $module => $accessLevel) {
                // Validate access level
                if (in_array($accessLevel, ['none', 'view', 'full'])) {
                    $insertResult = executeNonQuery($insertSql, [$memberId, $module, $accessLevel]);
                    
                    // Check if insertion was successful
                    if ($insertResult === false) {
                        throw new Exception("Failed to insert permission for module: $module");
                    }
                }
            }
        }
        
        commitTransaction();
        
        http_response_code(200);
        echo json_encode(['message' => 'Permissions saved successfully']);
    } catch (Exception $e) {
        rollbackTransaction();
        error_log("Error saving permissions for member ID $memberId: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => 'Failed to save permissions: ' . $e->getMessage()]);
    }
}

function deleteMemberPermissions($memberId) {
    try {
        // Validate member ID
        if (empty($memberId)) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid member ID']);
            return;
        }
        
        $sql = "DELETE FROM admin_module_permissions WHERE member_id = ?";
        $result = executeNonQuery($sql, [$memberId]);
        
        // Check if deletion was successful
        if ($result === false) {
            throw new Exception("Failed to delete permissions");
        }
        
        http_response_code(200);
        echo json_encode(['message' => 'Permissions deleted successfully']);
    } catch (Exception $e) {
        error_log("Error deleting permissions for member ID $memberId: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => 'Failed to delete permissions: ' . $e->getMessage()]);
    }
}
*/
?>