# MFT Group Management System

A comprehensive financial management system for savings groups and cooperatives.

## Overview

The MFT Group Management System is a web-based application designed to help savings groups, cooperatives, and similar organizations manage their financial operations efficiently. It provides features for member management, contribution tracking, loan processing, expense management, and reporting.

## Features

- Member Management
- Contribution Tracking
- Loan Processing
- Expense Management
- Financial Reporting
- Audit Trail
- Document Management
- Mobile Responsive Interface

## System Requirements

- PHP 7.4 or higher
- MySQL or MariaDB
- Apache or Nginx web server
- Composer (for dependency management)

## Installation

1. Clone or download the repository
2. Set up your web server to serve the project files
3. Create a MySQL database and import the schema from `database/mft_database_schema.sql`
4. Update the database configuration in `database/config.php`
5. Install PHP dependencies using Composer: `composer install`

For detailed installation instructions, see [database/INSTALL.md](database/INSTALL.md).

## Directory Structure

```
├── api/                 # REST API endpoints
├── css/                 # Stylesheets
├── database/            # Database schema and utilities
├── documents/           # Document storage
├── js/                  # JavaScript files
├── lib/                 # Third-party libraries
└── uploads/             # Uploaded files
```

## Available Scripts

### Cleanup Scripts

This project includes several scripts to remove test and debug files:

1. `delete_test_debug_files.php` - A PHP script
2. `delete_test_debug_files.bat` - A Windows batch script
3. `delete_test_debug_files.ps1` - A PowerShell script (Recommended)

See [DELETE_SCRIPTS_README.txt](DELETE_SCRIPTS_README.txt) for detailed usage instructions.

## API Documentation

The system provides a RESTful API for integration with external systems. See the [API documentation](api/) for details on available endpoints.

## Security

- All database queries use prepared statements to prevent SQL injection
- Input validation is performed on all API endpoints
- Passwords are securely hashed
- Session management is implemented for authentication

## Contributing

Contributions are welcome! Please follow these steps:

1. Fork the repository
2. Create a feature branch
3. Commit your changes
4. Push to the branch
5. Create a pull request

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Support

For support, please open an issue on the GitHub repository or contact the development team.