<?php
// Verify that project updates are actually being saved to the database
require_once 'database/config.php';

echo "<h1>Verify Project Updates</h1>";

try {
    $pdo = getDatabaseConnection();
    
    // Get all projects to see their current state
    $stmt = $pdo->query("SELECT id, name, description, location, completion_date, status, total_shares, share_price, updated_at FROM projects ORDER BY id");
    $projects = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Current Projects in Database</h2>";
    echo "<table border='1' cellpadding='5' cellspacing='0'>";
    echo "<tr><th>ID</th><th>Name</th><th>Description</th><th>Location</th><th>Updated At</th></tr>";
    
    foreach ($projects as $project) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($project['id']) . "</td>";
        echo "<td>" . htmlspecialchars($project['name']) . "</td>";
        echo "<td>" . htmlspecialchars($project['description']) . "</td>";
        echo "<td>" . htmlspecialchars($project['location']) . "</td>";
        echo "<td>" . htmlspecialchars($project['updated_at']) . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    // Test updating a specific project
    echo "<h2>Testing Update of Project ID 1</h2>";
    
    // Get current data
    $stmt = $pdo->prepare("SELECT id, name, description, location, updated_at FROM projects WHERE id = ?");
    $stmt->execute([1]);
    $current_project = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($current_project) {
        echo "<p>Current data for project ID 1:</p>";
        echo "<pre>" . htmlspecialchars(print_r($current_project, true)) . "</pre>";
        
        // Update with new data
        $new_name = "Verification Test Update " . date('Y-m-d H:i:s');
        $update_stmt = $pdo->prepare("UPDATE projects SET name = ?, updated_at = CURRENT_TIMESTAMP WHERE id = ?");
        $result = $update_stmt->execute([$new_name, 1]);
        
        echo "<p>Update result: " . ($result ? "SUCCESS" : "FAILED") . "</p>";
        echo "<p>Rows affected: " . $update_stmt->rowCount() . "</p>";
        
        // Verify the update
        $verify_stmt = $pdo->prepare("SELECT id, name, description, location, updated_at FROM projects WHERE id = ?");
        $verify_stmt->execute([1]);
        $updated_project = $verify_stmt->fetch(PDO::FETCH_ASSOC);
        
        echo "<p>After update:</p>";
        echo "<pre>" . htmlspecialchars(print_r($updated_project, true)) . "</pre>";
        
        if ($updated_project['name'] === $new_name) {
            echo "<p style='color: green;'>✅ Update verified successfully!</p>";
        } else {
            echo "<p style='color: red;'>❌ Update verification failed!</p>";
        }
    } else {
        echo "<p>Project ID 1 not found</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>