const fs = require('fs');
const path = require('path');

// Read the HTML file
const htmlContent = fs.readFileSync(path.join(__dirname, 'meetings.html'), 'utf8');

// Extract JavaScript content between <script> tags
const scriptMatch = htmlContent.match(/<script>([\s\S]*)<\/script>/);
if (!scriptMatch) {
  console.log('No script tags found');
  process.exit(1);
}

const scriptContent = scriptMatch[1];

// Try to parse the JavaScript
try {
  // This will throw an error if there are syntax errors
  new Function(scriptContent);
  console.log('JavaScript syntax is valid');
  process.exit(0);
} catch (error) {
  console.log('JavaScript syntax error:', error.message);
  process.exit(1);
}