<?php
require_once 'database/config.php';

try {
    // Test fetching a project
    $pdo = getDatabaseConnection();
    
    $stmt = $pdo->query("SELECT id, name, current_amount FROM projects LIMIT 1");
    $project = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($project) {
        echo "Project found:\n";
        echo "- ID: " . $project['id'] . "\n";
        echo "- Name: " . $project['name'] . "\n";
        echo "- Current Amount: " . $project['current_amount'] . "\n";
        
        // Test updating the current amount
        $new_amount = 15000.00;
        $update_stmt = $pdo->prepare("UPDATE projects SET current_amount = ? WHERE id = ?");
        $result = $update_stmt->execute([$new_amount, $project['id']]);
        
        if ($result) {
            echo "Project updated successfully with current amount: $new_amount\n";
            
            // Verify the update
            $verify_stmt = $pdo->prepare("SELECT current_amount FROM projects WHERE id = ?");
            $verify_stmt->execute([$project['id']]);
            $updated_project = $verify_stmt->fetch(PDO::FETCH_ASSOC);
            
            echo "Verified current amount: " . $updated_project['current_amount'] . "\n";
        } else {
            echo "Failed to update project\n";
        }
    } else {
        echo "No projects found\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>