<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Test inserting a new project with current_amount
    $stmt = $pdo->prepare("INSERT INTO projects (name, total_shares, share_price, current_amount, status) VALUES (?, ?, ?, ?, ?)");
    $result = $stmt->execute(['Test Project', 100, 500.00, 25000.00, 'Active']);
    
    if ($result) {
        $project_id = $pdo->lastInsertId();
        echo "Project created successfully with ID: $project_id\n";
        
        // Verify the current_amount was saved correctly
        $verify_stmt = $pdo->prepare("SELECT current_amount FROM projects WHERE id = ?");
        $verify_stmt->execute([$project_id]);
        $project = $verify_stmt->fetch(PDO::FETCH_ASSOC);
        
        echo "Current amount saved: " . $project['current_amount'] . "\n";
        
        // Test updating the current_amount
        $update_stmt = $pdo->prepare("UPDATE projects SET current_amount = ? WHERE id = ?");
        $update_result = $update_stmt->execute([30000.00, $project_id]);
        
        if ($update_result) {
            echo "Project updated successfully\n";
            
            // Verify the update
            $verify_stmt->execute([$project_id]);
            $updated_project = $verify_stmt->fetch(PDO::FETCH_ASSOC);
            
            echo "Current amount after update: " . $updated_project['current_amount'] . "\n";
        } else {
            echo "Failed to update project\n";
        }
        
        // Clean up - delete the test project
        $delete_stmt = $pdo->prepare("DELETE FROM projects WHERE id = ?");
        $delete_stmt->execute([$project_id]);
        echo "Test project deleted\n";
    } else {
        echo "Failed to create project\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>