<?php
// Test script to verify websocket server is accessible
require_once 'database/config.php';

echo "<h1>WebSocket Server Test</h1>";

// Test database connection
try {
    $pdo = getDatabaseConnection();
    echo "<p>✅ Database connection successful</p>";
} catch (Exception $e) {
    echo "<p>❌ Database connection failed: " . $e->getMessage() . "</p>";
    exit;
}

// Test if notifications table exists
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'notifications'");
    if ($stmt->rowCount() > 0) {
        echo "<p>✅ Notifications table exists</p>";
    } else {
        echo "<p>❌ Notifications table does not exist</p>";
    }
} catch (Exception $e) {
    echo "<p>❌ Error checking notifications table: " . $e->getMessage() . "</p>";
}

// Test if websocket-server.php is accessible
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://localhost/MFT/api/websocket-server.php");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$content_type = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
$error = curl_error($ch);

curl_close($ch);

echo "<h2>HTTP Test (via cURL)</h2>";
if ($error) {
    echo "<p>❌ cURL Error: " . $error . "</p>";
} else {
    echo "<p>✅ HTTP Request successful</p>";
    echo "<p>HTTP Code: " . $http_code . "</p>";
    echo "<p>Content Type: " . $content_type . "</p>";
    echo "<p>Response: " . htmlspecialchars(substr($response, 0, 200)) . (strlen($response) > 200 ? "..." : "") . "</p>";
}

// Also test HTTPS if possible
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://localhost/MFT/api/websocket-server.php");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Skip SSL verification for localhost testing
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // Skip SSL verification for localhost testing

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$content_type = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
$error = curl_error($ch);

curl_close($ch);

echo "<h2>HTTPS Test (via cURL)</h2>";
if ($error) {
    echo "<p>❌ cURL Error (HTTPS): " . $error . "</p>";
} else {
    echo "<p>✅ HTTPS Request successful</p>";
    echo "<p>HTTP Code: " . $http_code . "</p>";
    echo "<p>Content Type: " . $content_type . "</p>";
    echo "<p>Response: " . htmlspecialchars(substr($response, 0, 200)) . (strlen($response) > 200 ? "..." : "") . "</p>";
}

echo "<h2>Server Information</h2>";
echo "<p>PHP Version: " . phpversion() . "</p>";
echo "<p>Server Software: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "</p>";
echo "<p>Document Root: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'Unknown') . "</p>";
?>