<?php
// Test script to verify project update functionality after fix
require_once 'database/config.php';

echo "<h1>Project Update Test (After Fix)</h1>";

// Test database connection
try {
    $pdo = getDatabaseConnection();
    echo "<p>✅ Database connection successful</p>";
} catch (Exception $e) {
    echo "<p>❌ Database connection failed: " . $e->getMessage() . "</p>";
    exit;
}

// Get a test project to update
try {
    $stmt = $pdo->query("SELECT id, name, description, location, completion_date, status FROM projects LIMIT 1");
    $project = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($project) {
        echo "<p>✅ Found test project with ID: " . $project['id'] . "</p>";
        echo "<p>Current project data:</p>";
        echo "<pre>" . htmlspecialchars(print_r($project, true)) . "</pre>";
        
        // Test updating the project with the corrected field names
        $new_name = "Updated Project Name " . date('Y-m-d H:i:s');
        $new_description = "Updated description for testing";
        $new_location = "Updated Location";
        $new_completion_date = date('Y-m-d', strtotime('+60 days'));
        $new_status = "Active";
        
        // Prepare the update data matching the API expectations
        $update_data = [
            'name' => $new_name,
            'description' => $new_description,
            'location' => $new_location,
            'completion_date' => $new_completion_date,
            'status' => $new_status
        ];
        
        echo "<p>Updating project with corrected data:</p>";
        echo "<pre>" . htmlspecialchars(print_r($update_data, true)) . "</pre>";
        
        // Test the update function directly
        $updates = [];
        $params = [];
        
        // Map fields to database columns
        $field_mapping = [
            'name' => 'name',
            'description' => 'description',
            'location' => 'location',
            'completion_date' => 'completion_date',
            'status' => 'status'
        ];
        
        // Add fields to update
        foreach ($field_mapping as $frontend_field => $db_field) {
            if (isset($update_data[$frontend_field]) && $update_data[$frontend_field] !== '' && $update_data[$frontend_field] !== null) {
                $updates[] = "$db_field = ?";
                $params[] = $update_data[$frontend_field];
            }
        }
        
        if (!empty($updates)) {
            $params[] = $project['id']; // Add ID for WHERE clause
            $sql = "UPDATE projects SET " . implode(', ', $updates) . ", updated_at = CURRENT_TIMESTAMP WHERE id = ?";
            
            echo "<p>Executing SQL: $sql</p>";
            echo "<p>With parameters: " . json_encode($params) . "</p>";
            
            $stmt = $pdo->prepare($sql);
            $result = $stmt->execute($params);
            
            if ($result) {
                echo "<p>✅ Project updated successfully!</p>";
                
                // Fetch the updated project
                $stmt = $pdo->prepare("SELECT id, name, description, location, completion_date, status, updated_at FROM projects WHERE id = ?");
                $stmt->execute([$project['id']]);
                $updated_project = $stmt->fetch(PDO::FETCH_ASSOC);
                
                echo "<p>Updated project data:</p>";
                echo "<pre>" . htmlspecialchars(print_r($updated_project, true)) . "</pre>";
            } else {
                echo "<p>❌ Failed to update project</p>";
            }
        } else {
            echo "<p>❌ No valid fields to update</p>";
        }
    } else {
        echo "<p>❌ No projects found in database</p>";
    }
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>