<?php
// Test script to verify project members API is working
require_once 'database/config.php';

echo "<h1>Project Members API Test</h1>";

// Test database connection
try {
    $pdo = getDatabaseConnection();
    echo "<p>✅ Database connection successful</p>";
} catch (Exception $e) {
    echo "<p>❌ Database connection failed: " . $e->getMessage() . "</p>";
    exit;
}

// Test if member_projects table exists and has the correct structure
try {
    $stmt = $pdo->query("DESCRIBE member_projects");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<p>✅ member_projects table exists</p>";
    
    echo "<h2>member_projects table structure:</h2>";
    echo "<ul>";
    foreach ($columns as $column) {
        echo "<li>" . $column['Field'] . " (" . $column['Type'] . ")</li>";
    }
    echo "</ul>";
} catch (Exception $e) {
    echo "<p>❌ Error describing member_projects table: " . $e->getMessage() . "</p>";
}

// Test the specific query that was failing
try {
    // Try to get project members for project_id = 3 (as in the error logs)
    $sql = "SELECT m.id, m.member_id, m.first_name, m.last_name, m.email, m.phone, m.id_number, 
                   m.date_of_birth, m.gender, m.address, m.registration_date, m.status, m.membership_type,
                   mp.amount_contributed as contribution_amount, mp.join_date as joined_date, mp.status as member_project_status,
                   m.created_at, m.updated_at
            FROM members m
            JOIN member_projects mp ON m.id = mp.member_id
            WHERE mp.project_id = ?
            ORDER BY mp.join_date DESC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([3]);
    $members = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<p>✅ Project members query successful</p>";
    echo "<p>Found " . count($members) . " members for project ID 3</p>";
    
    if (count($members) > 0) {
        echo "<h2>Sample member data:</h2>";
        echo "<pre>" . htmlspecialchars(print_r($members[0], true)) . "</pre>";
    }
} catch (Exception $e) {
    echo "<p>❌ Error executing project members query: " . $e->getMessage() . "</p>";
}

// Test the members API directly
echo "<h2>Testing API endpoint</h2>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://localhost/MFT/api/members.php?project_id=3");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$content_type = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
$error = curl_error($ch);

curl_close($ch);

echo "<p>HTTP Code: " . $http_code . "</p>";
echo "<p>Content Type: " . $content_type . "</p>";

if ($error) {
    echo "<p>❌ cURL Error: " . $error . "</p>";
} else {
    echo "<p>✅ API Request successful</p>";
    echo "<p>Response: " . htmlspecialchars(substr($response, 0, 500)) . (strlen($response) > 500 ? "..." : "") . "</p>";
    
    // Try to parse JSON response
    $json = json_decode($response, true);
    if ($json) {
        echo "<p>✅ JSON Response parsed successfully</p>";
        if (isset($json['count'])) {
            echo "<p>Member count: " . $json['count'] . "</p>";
        }
    } else {
        echo "<p>❌ Failed to parse JSON response</p>";
    }
}
?>