<?php
// Test edge cases for project update
require_once 'database/config.php';

echo "<h1>Project Update Edge Cases Test</h1>";

// Test 1: Empty update data
echo "<h2>Test 1: Empty update data</h2>";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://localhost/MFT/api/projects.php?id=1");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([]));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Code: " . $http_code . "</p>";
echo "<p>Response: " . htmlspecialchars($response) . "</p>";

// Test 2: Update with null values
echo "<h2>Test 2: Update with null values</h2>";
$update_data = [
    'name' => null,
    'description' => null
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://localhost/MFT/api/projects.php?id=1");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($update_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Code: " . $http_code . "</p>";
echo "<p>Response: " . htmlspecialchars($response) . "</p>";

// Test 3: Update with empty strings
echo "<h2>Test 3: Update with empty strings</h2>";
$update_data = [
    'name' => '',
    'description' => ''
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://localhost/MFT/api/projects.php?id=1");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($update_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Code: " . $http_code . "</p>";
echo "<p>Response: " . htmlspecialchars($response) . "</p>";

// Test 4: Partial update
echo "<h2>Test 4: Partial update</h2>";
$update_data = [
    'name' => 'Partial Update Test ' . date('Y-m-d H:i:s')
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://localhost/MFT/api/projects.php?id=1");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($update_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Code: " . $http_code . "</p>";
echo "<p>Response: " . htmlspecialchars($response) . "</p>";

// Verify the update
echo "<h2>Verification</h2>";
try {
    $pdo = getDatabaseConnection();
    $stmt = $pdo->prepare("SELECT id, name, description, location FROM projects WHERE id = ?");
    $stmt->execute([1]);
    $project = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($project) {
        echo "<p>Current project data:</p>";
        echo "<pre>" . htmlspecialchars(print_r($project, true)) . "</pre>";
    } else {
        echo "<p>Project not found</p>";
    }
} catch (Exception $e) {
    echo "<p>Error verifying update: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>