<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    echo "Database connection successful\n";
    
    // Get a project to test with
    $stmt = $pdo->query('SELECT id, name, description, location FROM projects LIMIT 1');
    $project = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($project) {
        echo "Found project:\n";
        print_r($project);
        
        // Try to update it
        $new_name = "Test Update " . date('Y-m-d H:i:s');
        $sql = "UPDATE projects SET name = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $result = $stmt->execute([$new_name, $project['id']]);
        
        echo "Update result: " . ($result ? "SUCCESS" : "FAILED") . "\n";
        echo "Rows affected: " . $stmt->rowCount() . "\n";
        
        // Verify the update
        $verify_stmt = $pdo->prepare('SELECT id, name FROM projects WHERE id = ?');
        $verify_stmt->execute([$project['id']]);
        $updated_project = $verify_stmt->fetch(PDO::FETCH_ASSOC);
        
        echo "After update:\n";
        print_r($updated_project);
    } else {
        echo "No projects found\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>