<?php
// Test the projects API update functionality
echo "<h1>Projects API Update Test</h1>";

// Test data to send
$update_data = [
    'name' => 'API Test Project Update ' . date('Y-m-d H:i:s'),
    'description' => 'Updated via API test script',
    'location' => 'API Test Location'
];

echo "<p>Sending update data:</p>";
echo "<pre>" . htmlspecialchars(json_encode($update_data, JSON_PRETTY_PRINT)) . "</pre>";

// Use cURL to test the API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://localhost/MFT/api/projects.php?id=1");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($update_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Content-Length: ' . strlen(json_encode($update_data))
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$content_type = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
$error = curl_error($ch);

curl_close($ch);

echo "<p>HTTP Code: " . $http_code . "</p>";
echo "<p>Content Type: " . $content_type . "</p>";

if ($error) {
    echo "<p>Error: " . htmlspecialchars($error) . "</p>";
} else {
    echo "<p>Response:</p>";
    echo "<pre>" . htmlspecialchars($response) . "</pre>";
}

// Verify the update
echo "<h2>Verification</h2>";
require_once 'database/config.php';
try {
    $pdo = getDatabaseConnection();
    $stmt = $pdo->prepare("SELECT id, name, description, location FROM projects WHERE id = ?");
    $stmt->execute([1]);
    $project = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($project) {
        echo "<p>Current project data:</p>";
        echo "<pre>" . htmlspecialchars(print_r($project, true)) . "</pre>";
    } else {
        echo "<p>Project not found</p>";
    }
} catch (Exception $e) {
    echo "<p>Error verifying update: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>