<?php

namespace setasign\Fpdi;

/**
 * Minimal implementation of FpdiTrait for compatibility with mPDF
 */
trait FpdiTrait
{
    /**
     * Write a PDF type to the document
     */
    public function writePdfType($value)
    {
        // Minimal implementation
        return $value;
    }
    
    /**
     * Use an imported page
     */
    public function useImportedPage($pageId, $x = 0, $y = 0, $width = null, $height = null, $adjustPageSize = false)
    {
        // Minimal implementation
        return ['width' => $width, 'height' => $height];
    }
    
    /**
     * Import a page
     */
    public function importPage($pageNumber, $box = 'CropBox', $groupXObject = true)
    {
        // Minimal implementation
        return 'page-' . $pageNumber;
    }
}