<?php
/**
 * Simple autoloader for Dompdf
 */

spl_autoload_register(function ($class) {
    // Check if the class belongs to the Dompdf namespace
    if (strpos($class, 'Dompdf\\') === 0) {
        // Remove the namespace prefix
        $relativeClass = substr($class, 7);
        
        // Special case for Cpdf class which is in lib directory
        if ($relativeClass === 'Cpdf') {
            $file = __DIR__ . '/lib/Cpdf.php';
        } else {
            // Replace namespace separators with directory separators
            $file = __DIR__ . '/src/' . str_replace('\\', '/', $relativeClass) . '.php';
        }
        
        // If the file exists, require it
        if (file_exists($file)) {
            require_once $file;
        }
    }
});
?>