// Granular Permissions System for MFT GROUP Admin Dashboard
// This file provides functions to check granular module permissions (none, view, full)

/**
 * Check if user has specific access level for a module
 * @param {string} module - The module name (e.g., 'contributions', 'loans', 'members')
 * @param {string} accessLevel - The required access level ('view' or 'full')
 * @returns {boolean} - True if user has the required access level or higher
 */
async function hasModulePermission(module, accessLevel) {
    // DISABLED: All users now have full access to all modules
    return true;
    
    /*
    try {
        // Get admin ID from session storage
        const adminData = sessionStorage.getItem('adminData');
        if (!adminData) {
            console.warn('No admin data found in session storage');
            return false;
        }
        
        const admin = JSON.parse(adminData);
        const adminId = admin.id;
        
        if (!adminId) {
            console.warn('No admin ID found in admin data');
            return false;
        }
        
        // Check if we have cached permissions
        const cachedPermissions = sessionStorage.getItem('adminModulePermissions');
        let permissions = {};
        
        if (cachedPermissions) {
            try {
                const cached = JSON.parse(cachedPermissions);
                // Check if cache is still valid (less than 5 minutes old)
                if (cached.timestamp && (Date.now() - cached.timestamp < 300000)) {
                    permissions = cached.permissions;
                }
            } catch (e) {
                console.warn('Failed to parse cached permissions', e);
            }
        }
        
        // If no valid cache, fetch permissions from server
        if (Object.keys(permissions).length === 0) {
            try {
                const response = await fetch(`/MFT/api/admin-permissions.php?member_id=${adminId}`);
                if (response.ok) {
                    const data = await response.json();
                    if (data.permissions) {
                        permissions = data.permissions;
                        // Cache permissions with timestamp
                        sessionStorage.setItem('adminModulePermissions', JSON.stringify({
                            permissions: permissions,
                            timestamp: Date.now()
                        }));
                    }
                }
            } catch (error) {
                console.error('Error fetching permissions:', error);
                // Fallback to role-based permissions
                return hasRolePermission(module, accessLevel);
            }
        }
        
        // Check if user has the required permission
        const userAccessLevel = permissions[module] || 'none';
        
        // Define access level hierarchy
        const accessLevels = {
            'none': 0,
            'view': 1,
            'full': 2
        };
        
        // Return true if user's access level is equal or higher than required
        return accessLevels[userAccessLevel] >= accessLevels[accessLevel];
    } catch (error) {
        console.error('Error checking module permission:', error);
        // Fallback to role-based permissions
        return hasRolePermission(module, accessLevel);
    }
    */
}

/**
 * Fallback function that uses role-based permissions
 * @param {string} module - The module name
 * @param {string} accessLevel - The required access level
 * @returns {boolean} - True if user has the required access based on role
 */
function hasRolePermission(module, accessLevel) {
    // DISABLED: All users now have full access to all modules
    return true;
    
    /*
    try {
        const adminData = sessionStorage.getItem('adminData');
        if (adminData) {
            const admin = JSON.parse(adminData);
            const role = admin.role || 'Member';
            
            // Define role permissions
            const rolePermissions = {
                'Admin': ['all'],
                'Treasurer': ['finance', 'reports', 'contributions', 'loans', 'expenses'],
                'Secretary': ['members', 'documents', 'meetings', 'finance'],
                'Chairman': ['members', 'meetings', 'reports', 'finance', 'contributions', 'loans'],
                'Assistant Chairman': ['members', 'meetings', 'reports', 'finance', 'contributions', 'loans'],
                'Assistant Secretary': ['members', 'documents', 'meetings', 'finance'],
                'Loans Officer': ['loans', 'reports', 'finance'],
                'Member': ['profile', 'contributions', 'loans', 'documents', 'finance']
            };
            
            const permissions = rolePermissions[role] || [];
            
            // Admin has access to everything
            if (permissions.includes('all')) {
                return true;
            }
            
            // For 'full' access level, user needs exact module permission
            // For 'view' access level, user needs either exact module permission or 'all'
            return permissions.includes(module);
        }
    } catch (e) {
        console.error('Error checking role permissions:', e);
    }
    return false;
    */
}

/**
 * Check if user has view access to a module
 * @param {string} module - The module name
 * @returns {boolean} - True if user has view or full access
 */
async function canViewModule(module) {
    // DISABLED: All users now have full access to all modules
    return true;
    
    // return await hasModulePermission(module, 'view');
}

/**
 * Check if user has full access to a module
 * @param {string} module - The module name
 * @returns {boolean} - True if user has full access
 */
async function canModifyModule(module) {
    // DISABLED: All users now have full access to all modules
    return true;
    
    // return await hasModulePermission(module, 'full');
}

// Export functions for global use
window.hasModulePermission = hasModulePermission;
window.canViewModule = canViewModule;
window.canModifyModule = canModifyModule;